/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.statistics;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.TimeController;
import org.evosuite.statistics.OutputVariable;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.testsuite.TestSuiteChromosome;

public abstract class SequenceOutputVariableFactory<T extends Number> {
    protected RuntimeVariable variable;
    protected List<Long> timeStamps = new ArrayList<Long>();
    protected List<T> values = new ArrayList<T>();
    private long startTime = 0L;

    public SequenceOutputVariableFactory(RuntimeVariable variable) {
        this.variable = variable;
    }

    public void setStartTime(long time) {
        this.startTime = time;
    }

    protected abstract T getValue(TestSuiteChromosome var1);

    public void update(TestSuiteChromosome individual) {
        this.timeStamps.add(System.currentTimeMillis() - this.startTime);
        this.values.add(this.getValue(individual));
    }

    public List<String> getVariableNames() {
        ArrayList<String> variables = new ArrayList<String>();
        for (String suffix : this.getTimelineHeaderSuffixes()) {
            variables.add(this.variable.name() + suffix);
        }
        return variables;
    }

    public List<OutputVariable<T>> getOutputVariables() {
        ArrayList<OutputVariable<T>> variables = new ArrayList<OutputVariable<T>>();
        for (String variableName : this.getVariableNames()) {
            OutputVariable<T> variable = new OutputVariable<T>(variableName, this.getTimeLineValue(variableName));
            variables.add(variable);
        }
        return variables;
    }

    private T getTimeLineValue(String name) {
        long interval = Properties.TIMELINE_INTERVAL;
        int index = Integer.parseInt(name.split("_T")[1]);
        long preferredTime = interval * (long)index;
        if (this.timeStamps.isEmpty()) {
            return (T)Integer.valueOf(0);
        }
        for (int i = 0; i < this.timeStamps.size(); ++i) {
            long stamp = this.timeStamps.get(i);
            if (stamp < preferredTime) continue;
            if (i == 0) {
                return (T)((Number)this.values.get(i));
            }
            if (!Properties.TIMELINE_INTERPOLATION) {
                return (T)((Number)this.values.get(i - 1));
            }
            long timeDelta = this.timeStamps.get(i) - this.timeStamps.get(i - 1);
            if (timeDelta <= 0L) continue;
            double covDelta = ((Number)this.values.get(i)).doubleValue() - ((Number)this.values.get(i - 1)).doubleValue();
            double ratio = covDelta / (double)timeDelta;
            long diff = preferredTime - this.timeStamps.get(i - 1);
            Double cov = ((Number)this.values.get(i - 1)).doubleValue() + (double)diff * ratio;
            return (T)cov;
        }
        return (T)((Number)this.values.get(this.values.size() - 1));
    }

    private String[] getTimelineHeaderSuffixes() {
        int numberOfIntervals = this.calculateNumberOfIntervals();
        String[] suffixes = new String[numberOfIntervals];
        for (int i = 0; i < suffixes.length; ++i) {
            suffixes[i] = "_T" + (i + 1);
        }
        return suffixes;
    }

    private int calculateNumberOfIntervals() {
        long interval = Properties.TIMELINE_INTERVAL;
        long totalTime = (long)TimeController.getSearchBudgetInSeconds() * 1000L;
        int numberOfIntervals = (int)(totalTime / interval);
        return numberOfIntervals;
    }
}

