/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic;

public class ConstraintTypeCounter {
    private final int[] countersByType = new int[8];
    private static final int INTEGER_CONSTRAINT_KEY = 1;
    private static final int REAL_CONSTRAINT_KEY = 2;
    private static final int STRING_CONSTRAINT_KEY = 4;

    public void addNewConstraint(boolean isInteger, boolean isReal, boolean isString) {
        int key;
        int n = key = ConstraintTypeCounter.getKey(isInteger, isReal, isString);
        this.countersByType[n] = this.countersByType[n] + 1;
    }

    private static int getKey(boolean isIntegerConstraint, boolean isRealConstraint, boolean isStringConstraint) {
        int key = 0;
        if (isIntegerConstraint) {
            key |= 1;
        }
        if (isRealConstraint) {
            key |= 2;
        }
        if (isStringConstraint) {
            key |= 4;
        }
        return key;
    }

    public void clear() {
        for (int i = 0; i < this.countersByType.length; ++i) {
            this.countersByType[i] = 0;
        }
    }

    public int getTotalNumberOfConstraints() {
        int count = 0;
        for (int k : this.countersByType) {
            count += k;
        }
        return count;
    }

    public int getIntegerOnlyConstraints() {
        int key = ConstraintTypeCounter.getKey(true, false, false);
        return this.countersByType[key];
    }

    public int getRealOnlyConstraints() {
        int key = ConstraintTypeCounter.getKey(false, true, false);
        return this.countersByType[key];
    }

    public int getStringOnlyConstraints() {
        int key = ConstraintTypeCounter.getKey(false, false, true);
        return this.countersByType[key];
    }

    public int getIntegerAndRealConstraints() {
        int key = ConstraintTypeCounter.getKey(true, true, false);
        return this.countersByType[key];
    }

    public int getIntegerAndStringConstraints() {
        int key = ConstraintTypeCounter.getKey(true, false, true);
        return this.countersByType[key];
    }

    public int getRealAndStringConstraints() {
        int key = ConstraintTypeCounter.getKey(false, true, true);
        return this.countersByType[key];
    }

    public int getIntegerRealAndStringConstraints() {
        int key = ConstraintTypeCounter.getKey(true, true, true);
        return this.countersByType[key];
    }
}

