/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.expr.token;

import java.util.HashSet;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.symbolic.ConstraintTooLongException;
import org.evosuite.symbolic.expr.ExpressionVisitor;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.expr.str.StringValue;
import org.evosuite.symbolic.expr.token.TokenizerExpr;

public final class NewTokenizerExpr
extends TokenizerExpr {
    private static final long serialVersionUID = -6640965868758291282L;
    private final StringValue string;
    private final StringValue delim;

    public NewTokenizerExpr(StringValue string, StringValue delim) {
        super(1 + string.getSize() + delim.getSize(), string.containsSymbolicVariable() || delim.containsSymbolicVariable());
        this.string = string;
        this.delim = delim;
        if (this.getSize() > Properties.DSE_CONSTRAINT_LENGTH) {
            throw new ConstraintTooLongException(this.getSize());
        }
    }

    @Override
    public Set<Variable<?>> getVariables() {
        HashSet variables = new HashSet();
        variables.addAll(this.string.getVariables());
        variables.addAll(this.delim.getVariables());
        return variables;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof NewTokenizerExpr) {
            NewTokenizerExpr that = (NewTokenizerExpr)obj;
            return this.string.equals(that.string) && this.delim.equals(that.delim);
        }
        return false;
    }

    public int hashCode() {
        return this.string.hashCode() + this.delim.hashCode();
    }

    public String toString() {
        String toString = String.format("TOKENIZE(%s, %s)", this.string.toString(), this.delim.toString());
        return toString;
    }

    @Override
    public StringValue getDelimiter() {
        return this.delim;
    }

    @Override
    public StringValue getString() {
        return this.string;
    }

    @Override
    public int getNextTokenCount() {
        return 0;
    }

    @Override
    public Set<Object> getConstants() {
        HashSet<Object> result = new HashSet<Object>();
        result.add(this.delim.getConcreteValue());
        result.add(this.string.getConcreteValue());
        return result;
    }

    @Override
    public <K, V> K accept(ExpressionVisitor<K, V> v, V arg) {
        return v.visit(this, arg);
    }
}

