/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.evosuite.symbolic.solver.Solver;
import org.evosuite.utils.ProcessLauncher;
import org.evosuite.utils.ProcessTimeoutException;

public abstract class SubProcessSolver
extends Solver {
    public SubProcessSolver(boolean addMissingVariables) {
        super(addMissingVariables);
    }

    public SubProcessSolver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int launchNewProcess(String solverCmd, String smtQuery, int hard_timeout, OutputStream outputStream) throws IOException {
        ByteArrayInputStream input = new ByteArrayInputStream(smtQuery.getBytes());
        ProcessLauncher launcher = new ProcessLauncher(outputStream, input);
        long solver_start_time_millis = System.currentTimeMillis();
        try {
            int exit_code = launcher.launchNewProcess(solverCmd, hard_timeout);
            if (exit_code == 0) {
                logger.debug("Solver execution finished normally");
            } else {
                logger.debug("Solver execution finished abnormally with exit code {}", (Object)exit_code);
            }
            int n = exit_code;
            return n;
        }
        catch (IOException ex) {
            logger.debug("An IO Exception occurred while executing Solver");
            int n = -1;
            return n;
        }
        catch (ProcessTimeoutException ex) {
            logger.debug("Solver execution stopped due to solver timeout");
            int n = -1;
            return n;
        }
        finally {
            long solver_end_time_millis = System.currentTimeMillis();
            long solver_duration_secs = (solver_end_time_millis - solver_start_time_millis) / 1000L;
            logger.debug("Solver execution time was {}s", (Object)solver_duration_secs);
        }
    }
}

