/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.z3;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.evosuite.symbolic.solver.ResultParser;
import org.evosuite.symbolic.solver.SolverParseException;
import org.evosuite.symbolic.solver.SolverResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Z3ResultParser
extends ResultParser {
    private final Map<String, Object> initialValues;
    static Logger logger = LoggerFactory.getLogger(Z3ResultParser.class);

    public Z3ResultParser(Map<String, Object> initialValues) {
        this.initialValues = initialValues;
    }

    public Z3ResultParser() {
        this.initialValues = null;
    }

    public SolverResult parseResult(String z3ResultStr) throws SolverParseException {
        if (z3ResultStr.startsWith("sat")) {
            logger.debug("Z3 outcome was SAT");
            Map<String, Object> solution = this.parseModel(z3ResultStr);
            SolverResult satResult = SolverResult.newSAT(solution);
            return satResult;
        }
        if (z3ResultStr.startsWith("unsat")) {
            logger.debug("Z3 outcome was UNSAT");
            SolverResult unsatResult = SolverResult.newUNSAT();
            return unsatResult;
        }
        logger.debug("Z3 output was " + z3ResultStr);
        throw new SolverParseException("Z3 output is unknown. We are unable to parse it to a proper solution!", z3ResultStr);
    }

    private Map<String, Object> parseModel(String z3ResultStr) {
        HashMap<String, Object> solution = new HashMap<String, Object>();
        HashMap<String, String> arraysToFuncMap = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(z3ResultStr, "() \n\t");
        tokenizer.nextToken();
        tokenizer.nextToken();
        while (tokenizer.hasMoreTokens()) {
            Number value;
            String token = tokenizer.nextToken();
            if (!token.equals("define-fun")) continue;
            String funcName = tokenizer.nextToken();
            String typeName = tokenizer.nextToken();
            if (typeName.equals("Int")) {
                String integerValueStr = tokenizer.nextToken();
                if (integerValueStr.equals("-")) {
                    String absoluteIntegerValue = tokenizer.nextToken();
                    value = Long.parseLong("-" + absoluteIntegerValue);
                } else {
                    value = Long.parseLong(integerValueStr);
                }
                solution.put(funcName, value);
                continue;
            }
            if (typeName.equals("Real")) {
                String realValueStr = tokenizer.nextToken();
                if (realValueStr.equals("-")) {
                    String absoluteValueStr = tokenizer.nextToken();
                    if (absoluteValueStr.equals("/")) {
                        String numeratorStr = tokenizer.nextToken();
                        String denominatorStr = tokenizer.nextToken();
                        value = Z3ResultParser.parseRational(true, numeratorStr, denominatorStr);
                    } else {
                        value = Double.parseDouble("-" + absoluteValueStr);
                    }
                } else if (realValueStr.equals("/")) {
                    String numeratorStr = tokenizer.nextToken();
                    String denominatorStr = tokenizer.nextToken();
                    value = Z3ResultParser.parseRational(false, numeratorStr, denominatorStr);
                } else {
                    value = Double.parseDouble(realValueStr);
                }
                solution.put(funcName, value);
                continue;
            }
            if (typeName.equals("Array")) {
                tokenizer.nextToken();
                tokenizer.nextToken();
                tokenizer.nextToken();
                tokenizer.nextToken();
                String arrayFuncName = tokenizer.nextToken();
                arraysToFuncMap.put(arrayFuncName, funcName);
                continue;
            }
            if (!typeName.equals("x!1")) continue;
        }
        if (solution.isEmpty()) {
            logger.warn("The Z3 model has no variables");
        } else {
            logger.debug("Parsed values from Z3 output");
            for (String varName : solution.keySet()) {
                String valueOf = String.valueOf(solution.get(varName));
                logger.debug(varName + ":" + valueOf);
            }
        }
        if (this.initialValues != null) {
            logger.debug("Adding missing values to Solver solution");
            Z3ResultParser.addMissingValues(this.initialValues, solution);
        }
        return solution;
    }

    private static void addMissingValues(Map<String, Object> initialValues, Map<String, Object> solution) {
        for (String otherVarName : initialValues.keySet()) {
            if (solution.containsKey(otherVarName)) continue;
            solution.put(otherVarName, initialValues.get(otherVarName));
        }
    }
}

