/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.z3str2;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.evosuite.Properties;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.solver.SmtExprBuilder;
import org.evosuite.symbolic.solver.SolverEmptyQueryException;
import org.evosuite.symbolic.solver.SolverErrorException;
import org.evosuite.symbolic.solver.SolverParseException;
import org.evosuite.symbolic.solver.SolverResult;
import org.evosuite.symbolic.solver.SolverTimeoutException;
import org.evosuite.symbolic.solver.SubProcessSolver;
import org.evosuite.symbolic.solver.smt.SmtAssertion;
import org.evosuite.symbolic.solver.smt.SmtCheckSatQuery;
import org.evosuite.symbolic.solver.smt.SmtConstantDeclaration;
import org.evosuite.symbolic.solver.smt.SmtExpr;
import org.evosuite.symbolic.solver.smt.SmtFunctionDefinition;
import org.evosuite.symbolic.solver.smt.SmtIntVariable;
import org.evosuite.symbolic.solver.smt.SmtOperation;
import org.evosuite.symbolic.solver.smt.SmtOperatorCollector;
import org.evosuite.symbolic.solver.smt.SmtRealVariable;
import org.evosuite.symbolic.solver.smt.SmtStringVariable;
import org.evosuite.symbolic.solver.smt.SmtVariable;
import org.evosuite.symbolic.solver.smt.SmtVariableCollector;
import org.evosuite.symbolic.solver.z3.Z3Solver;
import org.evosuite.symbolic.solver.z3str2.ConstraintToZ3Str2Visitor;
import org.evosuite.symbolic.solver.z3str2.ExprToZ3Str2Visitor;
import org.evosuite.symbolic.solver.z3str2.Z3Str2QueryPrinter;
import org.evosuite.symbolic.solver.z3str2.Z3Str2ResultParser;
import org.evosuite.testcase.execution.EvosuiteError;
import org.evosuite.utils.FileIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z3Str2Solver
extends SubProcessSolver {
    private static final String EVOSUITE_Z3_STR_FILENAME = "evosuite.z3";
    static Logger logger = LoggerFactory.getLogger(Z3Solver.class);
    private static int dirCounter = 0;
    private static final int ASCII_TABLE_LENGTH = 90;

    public Z3Str2Solver() {
    }

    public Z3Str2Solver(boolean addMissingVariables) {
        super(addMissingVariables);
    }

    private static File createNewTmpDir() {
        File dir = null;
        String dirName = FileUtils.getTempDirectoryPath() + File.separator + "EvoSuiteZ3Str_" + dirCounter++ + "_" + System.currentTimeMillis();
        dir = new File(dirName);
        if (!dir.mkdirs()) {
            logger.error("Cannot create tmp dir: " + dirName);
            return null;
        }
        if (!dir.exists()) {
            logger.error("Weird behavior: we created folder, but Java cannot determine if it exists? Folder: " + dirName);
            return null;
        }
        return dir;
    }

    private static SmtCheckSatQuery buildSmtQuerty(Collection<Constraint<?>> constraints) {
        ConstraintToZ3Str2Visitor v = new ConstraintToZ3Str2Visitor();
        LinkedList<SmtAssertion> assertions = new LinkedList<SmtAssertion>();
        SmtVariableCollector varCollector = new SmtVariableCollector();
        SmtOperatorCollector opCollector = new SmtOperatorCollector();
        for (Constraint<?> c : constraints) {
            SmtExpr smtExpr = c.accept(v, null);
            if (smtExpr == null) continue;
            SmtAssertion newAssertion = new SmtAssertion(smtExpr);
            assertions.add(newAssertion);
            smtExpr.accept(varCollector, null);
            smtExpr.accept(opCollector, null);
        }
        Set<SmtVariable> smtVariables = varCollector.getSmtVariables();
        Set<SmtOperation.Operator> smtOperators = opCollector.getOperators();
        boolean addCharToIntFunction = smtOperators.contains((Object)SmtOperation.Operator.CHAR_TO_INT);
        HashSet<SmtVariable> smtVariablesToDeclare = new HashSet<SmtVariable>(smtVariables);
        if (addCharToIntFunction) {
            Set<SmtStringVariable> charVariables = Z3Str2Solver.buildCharVariables();
            smtVariablesToDeclare.addAll(charVariables);
        }
        LinkedList<SmtConstantDeclaration> constantDeclarations = new LinkedList<SmtConstantDeclaration>();
        for (SmtVariable v1 : smtVariablesToDeclare) {
            SmtConstantDeclaration constantDecl;
            String varName = v1.getName();
            if (v1 instanceof SmtIntVariable) {
                constantDecl = SmtExprBuilder.mkIntConstantDeclaration(varName);
                constantDeclarations.add(constantDecl);
                continue;
            }
            if (v1 instanceof SmtRealVariable) {
                constantDecl = SmtExprBuilder.mkRealConstantDeclaration(varName);
                constantDeclarations.add(constantDecl);
                continue;
            }
            if (v1 instanceof SmtStringVariable) {
                constantDecl = SmtExprBuilder.mkStringConstantDeclaration(varName);
                constantDeclarations.add(constantDecl);
                continue;
            }
            throw new RuntimeException("Unknown variable type " + v1.getClass().getCanonicalName());
        }
        LinkedList<SmtFunctionDefinition> functionDefinitions = new LinkedList<SmtFunctionDefinition>();
        if (addCharToIntFunction) {
            String charToInt = Z3Str2Solver.buildCharToIntFunction();
            SmtFunctionDefinition newFunctionDef = new SmtFunctionDefinition(charToInt);
            functionDefinitions.add(newFunctionDef);
        }
        SmtCheckSatQuery smtCheckSatQuery = new SmtCheckSatQuery(constantDeclarations, functionDefinitions, assertions);
        return smtCheckSatQuery;
    }

    @Override
    public SolverResult solve(Collection<Constraint<?>> constraints) throws SolverTimeoutException, IOException, SolverParseException, SolverEmptyQueryException, SolverErrorException {
        SmtCheckSatQuery smtCheckSatQuery = Z3Str2Solver.buildSmtQuerty(constraints);
        if (smtCheckSatQuery.getConstantDeclarations().isEmpty()) {
            logger.debug("Z3-str2 input has no variables");
            throw new SolverEmptyQueryException("Z3-str2 input has no variables");
        }
        if (smtCheckSatQuery.getAssertions().isEmpty()) {
            HashMap<String, Object> emptySolution = new HashMap<String, Object>();
            SolverResult emptySAT = SolverResult.newSAT(emptySolution);
            return emptySAT;
        }
        Z3Str2QueryPrinter printer = new Z3Str2QueryPrinter();
        String smtQueryStr = printer.print(smtCheckSatQuery);
        logger.debug("Z3-str2 input:");
        logger.debug(smtQueryStr);
        int timeout = (int)Properties.DSE_CONSTRAINT_SOLVER_TIMEOUT_MILLIS;
        File tempDir = Z3Str2Solver.createNewTmpDir();
        String z3TempFileName = tempDir.getAbsolutePath() + File.separatorChar + EVOSUITE_Z3_STR_FILENAME;
        if (Properties.Z3_STR2_PATH == null) {
            String errMsg = "Property Z3_STR_PATH should be setted in order to use the Z3StrSolver!";
            logger.error(errMsg);
            throw new IllegalStateException(errMsg);
        }
        try {
            boolean check;
            FileIOUtils.writeFile(smtQueryStr, z3TempFileName);
            String z3Cmd = Properties.Z3_STR2_PATH + " -f " + z3TempFileName;
            ByteArrayOutputStream stdout = new ByteArrayOutputStream();
            Z3Str2Solver.launchNewProcess(z3Cmd, smtQueryStr, timeout, stdout);
            String z3str2ResultStr = stdout.toString("UTF-8");
            Z3Str2ResultParser parser = new Z3Str2ResultParser();
            Set<Variable<?>> variables = Z3Str2Solver.getVariables(constraints);
            Map<String, Object> initialValues = Z3Str2Solver.getConcreteValues(variables);
            SolverResult solverResult = this.addMissingVariables() ? parser.parse(z3str2ResultStr, initialValues) : parser.parse(z3str2ResultStr);
            if (solverResult.isSAT() && !(check = Z3Str2Solver.checkSAT(constraints, solverResult))) {
                SolverResult unsatResult;
                logger.debug("Z3-str2 solution does not solve the constraint system!");
                SolverResult solverResult2 = unsatResult = SolverResult.newUNSAT();
                return solverResult2;
            }
            SolverResult solverResult3 = solverResult;
            return solverResult3;
        }
        catch (UnsupportedEncodingException e) {
            throw new EvosuiteError("UTF-8 should not cause this exception!");
        }
        finally {
            File tempFile = new File(z3TempFileName);
            if (tempFile.exists()) {
                tempFile.delete();
            }
        }
    }

    private static Set<SmtStringVariable> buildCharVariables() {
        HashSet<SmtStringVariable> charVariables = new HashSet<SmtStringVariable>();
        for (int i = 0; i < 90; ++i) {
            char c = (char)i;
            String str = String.valueOf(c);
            String encodedStr = ExprToZ3Str2Visitor.encodeString(str);
            SmtStringVariable v = new SmtStringVariable(encodedStr);
            charVariables.add(v);
        }
        return charVariables;
    }

    private static String buildCharToIntFunction() {
        int i;
        StringBuffer buff = new StringBuffer();
        buff.append((Object)((Object)SmtOperation.Operator.CHAR_TO_INT) + "((x!1 String)) Int");
        buff.append("\n");
        for (i = 0; i < 90; ++i) {
            char c = (char)i;
            String str = String.valueOf(c);
            String encodedStr = ExprToZ3Str2Visitor.encodeString(str);
            if (i < 89) {
                String iteStr = String.format("(ite (= x!1 %s) %s", encodedStr, i);
                buff.append(iteStr);
                buff.append("\n");
                continue;
            }
            buff.append(i);
        }
        for (i = 0; i < 89; ++i) {
            buff.append(")");
        }
        buff.append("\n");
        return buff.toString();
    }
}

