/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.vm;

import org.evosuite.symbolic.expr.IntegerConstraint;
import org.evosuite.symbolic.expr.bv.IntegerValue;
import org.evosuite.symbolic.expr.fp.RealValue;
import org.evosuite.symbolic.expr.ref.ReferenceConstant;
import org.evosuite.symbolic.expr.ref.ReferenceExpression;
import org.evosuite.symbolic.vm.SymbolicEnvironment;
import org.objectweb.asm.Type;

public abstract class SymbolicFunction {
    protected final SymbolicEnvironment env;
    private final String owner;
    private final String name;
    private final String desc;
    private final Object[] symb_args;
    private final Object[] conc_args;
    private Object conc_receiver;
    private ReferenceExpression symb_receiver;
    private Object conc_ret_val;
    private Object symb_ret_val;

    public SymbolicFunction(SymbolicEnvironment env, String owner, String name, String desc) {
        this.env = env;
        this.owner = owner;
        this.name = name;
        this.desc = desc;
        this.symb_args = new Object[Type.getArgumentTypes((String)desc).length];
        this.conc_args = new Object[Type.getArgumentTypes((String)desc).length];
    }

    public final String getOwner() {
        return this.owner;
    }

    public final String getName() {
        return this.name;
    }

    void setReceiver(Object conc_receiver, ReferenceExpression symb_receiver) {
        this.conc_receiver = conc_receiver;
        this.symb_receiver = symb_receiver;
    }

    void setParam(int i, int conc_arg, IntegerValue symb_arg) {
        this.conc_args[i] = conc_arg;
        this.symb_args[i] = symb_arg;
    }

    void setParam(int i, char conc_arg, IntegerValue symb_arg) {
        this.conc_args[i] = Character.valueOf(conc_arg);
        this.symb_args[i] = symb_arg;
    }

    void setParam(int i, byte conc_arg, IntegerValue symb_arg) {
        this.conc_args[i] = conc_arg;
        this.symb_args[i] = symb_arg;
    }

    void setParam(int i, short conc_arg, IntegerValue symb_arg) {
        this.conc_args[i] = conc_arg;
        this.symb_args[i] = symb_arg;
    }

    void setParam(int i, boolean conc_arg, IntegerValue symb_arg) {
        this.conc_args[i] = conc_arg;
        this.symb_args[i] = symb_arg;
    }

    void setParam(int i, long conc_arg, IntegerValue symb_arg) {
        this.conc_args[i] = conc_arg;
        this.symb_args[i] = symb_arg;
    }

    void setParam(int i, float conc_arg, RealValue symb_arg) {
        this.conc_args[i] = Float.valueOf(conc_arg);
        this.symb_args[i] = symb_arg;
    }

    void setParam(int i, double conc_arg, RealValue symb_arg) {
        this.conc_args[i] = conc_arg;
        this.symb_args[i] = symb_arg;
    }

    void setParam(int i, Object conc_arg, ReferenceExpression symb_arg) {
        this.conc_args[i] = conc_arg;
        this.symb_args[i] = symb_arg;
    }

    void setReturnValue(int conc_ret_val, IntegerValue symb_ret_val) {
        this.conc_ret_val = conc_ret_val;
        this.symb_ret_val = symb_ret_val;
    }

    void setReturnValue(boolean conc_ret_val, IntegerValue symb_ret_val) {
        this.conc_ret_val = conc_ret_val;
        this.symb_ret_val = symb_ret_val;
    }

    void setReturnValue(long conc_ret_val, IntegerValue symb_ret_val) {
        this.conc_ret_val = conc_ret_val;
        this.symb_ret_val = symb_ret_val;
    }

    void setReturnValue(float conc_ret_val, RealValue symb_ret_val) {
        this.conc_ret_val = Float.valueOf(conc_ret_val);
        this.symb_ret_val = symb_ret_val;
    }

    void setReturnValue(double conc_ret_val, RealValue symb_ret_val) {
        this.conc_ret_val = conc_ret_val;
        this.symb_ret_val = symb_ret_val;
    }

    void setReturnValue(Object conc_ret_val, ReferenceExpression symb_ret_val) {
        this.conc_ret_val = conc_ret_val;
        this.symb_ret_val = symb_ret_val;
    }

    protected final ReferenceConstant getSymbReceiver() {
        return (ReferenceConstant)this.symb_receiver;
    }

    protected final Object getConcReceiver() {
        return this.conc_receiver;
    }

    protected final int getConcIntArgument(int i) {
        Integer int0 = (Integer)this.conc_args[i];
        return int0;
    }

    protected final short getConcShortArgument(int i) {
        Short short0 = (Short)this.conc_args[i];
        return short0;
    }

    protected final char getConcCharArgument(int i) {
        Character char0 = (Character)this.conc_args[i];
        return char0.charValue();
    }

    protected final double getConcDoubleArgument(int i) {
        Double double0 = (Double)this.conc_args[i];
        return double0;
    }

    protected final float getConcFloatArgument(int i) {
        Float float0 = (Float)this.conc_args[i];
        return float0.floatValue();
    }

    protected final boolean getConcBooleanArgument(int i) {
        Boolean boolean0 = (Boolean)this.conc_args[i];
        return boolean0;
    }

    protected final byte getConcByteArgument(int i) {
        Byte byte0 = (Byte)this.conc_args[i];
        return byte0;
    }

    protected final long getConcLongArgument(int i) {
        Long long0 = (Long)this.conc_args[i];
        return long0;
    }

    protected final Object getConcArgument(int i) {
        Object arg = this.conc_args[i];
        return arg;
    }

    protected final IntegerValue getSymbIntegerArgument(int i) {
        IntegerValue intExpr = (IntegerValue)this.symb_args[i];
        return intExpr;
    }

    protected final RealValue getSymbRealArgument(int i) {
        RealValue realExpr = (RealValue)this.symb_args[i];
        return realExpr;
    }

    protected final ReferenceExpression getSymbArgument(int i) {
        ReferenceExpression ref = (ReferenceExpression)this.symb_args[i];
        return ref;
    }

    protected final ReferenceExpression getSymbRetVal() {
        return (ReferenceExpression)this.symb_ret_val;
    }

    protected final IntegerValue getSymbIntegerRetVal() {
        IntegerValue intExpr = (IntegerValue)this.symb_ret_val;
        return intExpr;
    }

    protected final RealValue getSymbRealRetVal() {
        RealValue realExpr = (RealValue)this.symb_ret_val;
        return realExpr;
    }

    public abstract Object executeFunction();

    protected final int getConcIntRetVal() {
        Integer int0 = (Integer)this.conc_ret_val;
        return int0;
    }

    protected final short getConcShortRetVal() {
        Integer integer0 = (Integer)this.conc_ret_val;
        return integer0.shortValue();
    }

    protected final char getConcCharRetVal() {
        Integer char0 = (Integer)this.conc_ret_val;
        return (char)char0.intValue();
    }

    protected final double getConcDoubleRetVal() {
        Double double0 = (Double)this.conc_ret_val;
        return double0;
    }

    protected final float getConcFloatRetVal() {
        Float float0 = (Float)this.conc_ret_val;
        return float0.floatValue();
    }

    protected final boolean getConcBooleanRetVal() {
        Boolean boolean0 = (Boolean)this.conc_ret_val;
        return boolean0;
    }

    protected final byte getConcByteRetVal() {
        Integer integer0 = (Integer)this.conc_ret_val;
        return integer0.byteValue();
    }

    protected final long getConcLongRetVal() {
        Long long0 = (Long)this.conc_ret_val;
        return long0;
    }

    protected final Object getConcRetVal() {
        Object arg = this.conc_ret_val;
        return arg;
    }

    public final String getDesc() {
        return this.desc;
    }

    public IntegerConstraint beforeExecuteFunction() {
        return null;
    }
}

