/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.vm.math;

import org.evosuite.symbolic.expr.Operator;
import org.evosuite.symbolic.expr.bv.IntegerValue;
import org.evosuite.symbolic.expr.bv.RealUnaryToIntegerExpression;
import org.evosuite.symbolic.expr.fp.RealValue;
import org.evosuite.symbolic.vm.SymbolicEnvironment;
import org.evosuite.symbolic.vm.SymbolicFunction;
import org.evosuite.symbolic.vm.math.Types;

public abstract class Round {
    private static final String ROUND = "round";

    public static class Round_F
    extends SymbolicFunction {
        public Round_F(SymbolicEnvironment env) {
            super(env, Types.JAVA_LANG_MATH, Round.ROUND, Types.F2I_DESCRIPTOR);
        }

        @Override
        public Object executeFunction() {
            IntegerValue roundExpr;
            int res = this.getConcIntRetVal();
            RealValue realExpression = this.getSymbRealArgument(0);
            if (realExpression.containsSymbolicVariable()) {
                Operator op = Operator.ROUND;
                roundExpr = new RealUnaryToIntegerExpression(realExpression, op, Long.valueOf(res));
            } else {
                roundExpr = this.getSymbIntegerRetVal();
            }
            return roundExpr;
        }
    }

    public static class Round_D
    extends SymbolicFunction {
        public Round_D(SymbolicEnvironment env) {
            super(env, Types.JAVA_LANG_MATH, Round.ROUND, Types.D2L_DESCRIPTOR);
        }

        @Override
        public Object executeFunction() {
            IntegerValue roundExpr;
            long res = this.getConcLongRetVal();
            RealValue realExpression = this.getSymbRealArgument(0);
            if (realExpression.containsSymbolicVariable()) {
                Operator op = Operator.ROUND;
                roundExpr = new RealUnaryToIntegerExpression(realExpression, op, res);
            } else {
                roundExpr = this.getSymbIntegerRetVal();
            }
            return roundExpr;
        }
    }
}

