/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ReplacementFunction;
import org.evosuite.testcase.ExecutableChromosome;

public class TestCaseReplacementFunction
extends ReplacementFunction {
    private static final long serialVersionUID = 2894768695219052674L;

    public TestCaseReplacementFunction(boolean maximize) {
        super(maximize);
    }

    public TestCaseReplacementFunction() {
        super(false);
    }

    public int getLengthSum(ExecutableChromosome chromosome1, ExecutableChromosome chromosome2) {
        return chromosome1.size() + chromosome2.size();
    }

    @Override
    public boolean keepOffspring(Chromosome parent1, Chromosome parent2, Chromosome offspring1, Chromosome offspring2) {
        int cmp = this.compareBestOffspringToBestParent(parent1, parent2, offspring1, offspring2);
        if (Properties.CHECK_PARENTS_LENGTH) {
            int offspringLength = this.getLengthSum((ExecutableChromosome)offspring1, (ExecutableChromosome)offspring2);
            int parentLength = this.getLengthSum((ExecutableChromosome)parent1, (ExecutableChromosome)parent2);
            if (cmp == 0 && offspringLength <= parentLength) {
                return true;
            }
            if (this.maximize) {
                return cmp > 0;
            }
            return cmp < 0;
        }
        if (this.maximize) {
            return cmp >= 0;
        }
        return cmp <= 0;
    }
}

