/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import org.evosuite.Properties;
import org.evosuite.lm.StringLMOptimizer;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.TestVisitor;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.statements.ArrayStatement;
import org.evosuite.testcase.statements.AssignmentStatement;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.FieldStatement;
import org.evosuite.testcase.statements.FunctionalMockStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.NullStatement;
import org.evosuite.testcase.statements.PrimitiveExpression;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.ConstantValue;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueMinimizer
extends TestVisitor {
    private static Logger logger = LoggerFactory.getLogger(ValueMinimizer.class);
    private Minimization objective;

    public void minimize(TestChromosome test, TestFitnessFunction objective) {
        this.objective = new TestMinimization(objective, test);
        test.test.accept(this);
    }

    public void minimize(TestSuiteChromosome suite, TestSuiteFitnessFunction objective) {
        int i = 0;
        objective.getFitness(suite);
        for (TestChromosome test : suite.getTestChromosomes()) {
            this.objective = new SuiteMinimization(objective, suite, i);
            test.test.accept(this);
            ++i;
        }
    }

    private <N extends Number> N increment(N n, int x) {
        if (n instanceof Double) {
            return (N)Double.valueOf((Double)n + (double)x);
        }
        if (n instanceof Float) {
            return (N)Float.valueOf(((Float)n).floatValue() + (float)x);
        }
        if (n instanceof Integer) {
            return (N)Integer.valueOf((Integer)n + x);
        }
        if (n instanceof Long) {
            return (N)Long.valueOf((Long)n + (long)x);
        }
        if (n instanceof Short) {
            return (N)Short.valueOf((short)((Short)n + (short)x));
        }
        if (n instanceof Byte) {
            return (N)Byte.valueOf((byte)((Byte)n + (byte)x));
        }
        if (n == null) {
            throw new NullPointerException();
        }
        throw new IllegalArgumentException("Unexpected number type: " + n.getClass());
    }

    private <N extends Number> N getMid(N min, N max) {
        if (min instanceof Double) {
            return (N)Double.valueOf((Double)min + ((Double)max - (Double)min) / 2.0);
        }
        if (min instanceof Float) {
            return (N)Float.valueOf(((Float)min).floatValue() + (((Float)max).floatValue() - ((Float)min).floatValue()) / 2.0f);
        }
        if (min instanceof Integer) {
            return (N)Integer.valueOf((Integer)min + ((Integer)max - (Integer)min) / 2);
        }
        if (min instanceof Long) {
            return (N)Long.valueOf((Long)min + ((Long)max - (Long)min) / 2L);
        }
        if (min instanceof Short) {
            return (N)Short.valueOf((short)((Short)min + ((Short)max - (Short)min) / 2));
        }
        if (min instanceof Byte) {
            return (N)Byte.valueOf((byte)((Byte)min + ((Byte)max - (Byte)min) / 2));
        }
        if (min == null) {
            throw new NullPointerException();
        }
        throw new IllegalArgumentException("Unexpected number type: " + min.getClass());
    }

    private <N extends Number> N getZero(N n) {
        if (n instanceof Double) {
            return (N)Double.valueOf(0.0);
        }
        if (n instanceof Float) {
            return (N)Float.valueOf(0.0f);
        }
        if (n instanceof Integer) {
            return (N)Integer.valueOf(0);
        }
        if (n instanceof Long) {
            return (N)Long.valueOf(0L);
        }
        if (n instanceof Short) {
            return (N)Short.valueOf((short)0);
        }
        if (n instanceof Byte) {
            return (N)Byte.valueOf((byte)0);
        }
        if (n == null) {
            throw new NullPointerException();
        }
        throw new IllegalArgumentException("Unexpected number type: " + n.getClass());
    }

    private <T extends Number> void binarySearch(ConstantValue constantValue, T number) {
        Object min = this.getZero(number);
        Object max = number;
        boolean positive = number.doubleValue() >= 0.0;
        Object lastValue = null;
        boolean done = false;
        while (!done) {
            double oldVal;
            Object oldValue = constantValue.getValue();
            constantValue.setValue(this.getMid(min, max));
            Number newValue = (Number)constantValue.getValue();
            if (oldValue.equals(newValue) || lastValue != null && lastValue.equals(newValue)) break;
            if (lastValue instanceof Double && (oldVal = Math.abs((Double)lastValue)) < 1.0) {
                newValue = new Double(0.0);
                constantValue.setValue(newValue);
                if (this.objective.isNotWorse()) break;
                constantValue.setValue(lastValue);
                break;
            }
            if (lastValue instanceof Float && (oldVal = (double)Math.abs(((Float)lastValue).floatValue())) < 1.0) {
                newValue = new Float(0.0f);
                constantValue.setValue(newValue);
                if (this.objective.isNotWorse()) break;
                constantValue.setValue(lastValue);
                break;
            }
            lastValue = newValue;
            logger.info("Trying " + constantValue.getValue() + " " + min + "/" + max + " - " + constantValue.getSimpleClassName());
            if (min.equals(max) || constantValue.getValue().equals(min) || constantValue.getValue().equals(max)) {
                done = true;
                logger.info("Fixpoint.");
            }
            if (this.objective.isNotWorse()) {
                logger.info("Fitness hasn't decreased");
                max = (Number)constantValue.getValue();
                continue;
            }
            logger.info("Fitness has decreased!");
            min = positive ? (Number)this.increment((Number)constantValue.getValue(), 1) : (Number)this.increment((Number)constantValue.getValue(), -1);
            constantValue.setValue(max);
            System.out.println("Setting value back to " + max);
            constantValue.getTestCase().clearCoveredGoals();
        }
        constantValue.getTestCase().clearCoveredGoals();
    }

    private void removeCharacters(ConstantValue constantValue) {
        assert (constantValue.getValue() instanceof String);
        String oldString = (String)constantValue.getValue();
        for (int i = oldString.length() - 1; i >= 0; --i) {
            String newString = oldString.substring(0, i) + oldString.substring(i + 1);
            constantValue.setValue(newString);
            if (this.objective.isNotWorse()) {
                oldString = (String)constantValue.getValue();
                continue;
            }
            constantValue.setValue(oldString);
        }
    }

    private void cleanString(ConstantValue constantValue) {
        assert (constantValue.getValue() instanceof String);
        String oldString = (String)constantValue.getValue();
        String newString = oldString.replaceAll("[^\\p{ASCII}]", "").replaceAll("\\p{Cntrl}", "");
        constantValue.setValue(newString);
        if (!this.objective.isNotWorse()) {
            constantValue.setValue(oldString);
            newString = oldString;
        }
        oldString = newString;
        newString = newString.replaceAll("[^\\p{L}\\p{N}]", "");
        constantValue.setValue(newString);
        if (!this.objective.isNotWorse()) {
            constantValue.setValue(oldString);
        }
    }

    private void replaceWithLanguageModel(ConstantValue constantValue) {
        assert (constantValue.getValue() instanceof String);
        String oldString = (String)constantValue.getValue();
        StringLMOptimizer slmo = new StringLMOptimizer(constantValue, this.objective);
        String newString = slmo.optimize();
        constantValue.setValue(newString);
        if (!this.objective.isNotWorse()) {
            constantValue.setValue(oldString);
        }
    }

    @Override
    public void visitTestCase(TestCase test) {
    }

    @Override
    public void visitStatement(Statement statement) {
        for (VariableReference var : statement.getVariableReferences()) {
            if (!(var instanceof ConstantValue)) continue;
            ConstantValue constantValue = (ConstantValue)var;
            Object value = constantValue.getValue();
            if (value instanceof String) {
                logger.info("Statement before minimization: " + statement.getCode());
                this.cleanString(constantValue);
                this.removeCharacters(constantValue);
                if (Properties.LM_STRINGS) {
                    this.replaceWithLanguageModel(constantValue);
                }
                logger.info("Statement after minimization: " + statement.getCode());
                continue;
            }
            if (!(value instanceof Number)) continue;
            logger.info("Statement before minimization: " + statement.getCode());
            this.binarySearch(constantValue, (Number)constantValue.getValue());
            logger.info("Statement after minimization: " + statement.getCode());
        }
    }

    @Override
    public void visitPrimitiveStatement(PrimitiveStatement<?> statement) {
    }

    @Override
    public void visitFieldStatement(FieldStatement statement) {
    }

    @Override
    public void visitMethodStatement(MethodStatement statement) {
    }

    @Override
    public void visitConstructorStatement(ConstructorStatement statement) {
    }

    @Override
    public void visitArrayStatement(ArrayStatement statement) {
    }

    @Override
    public void visitAssignmentStatement(AssignmentStatement statement) {
    }

    @Override
    public void visitNullStatement(NullStatement statement) {
    }

    @Override
    public void visitPrimitiveExpression(PrimitiveExpression primitiveExpression) {
        logger.warn("Method visitPrimitiveExpression not implemented!");
    }

    @Override
    public void visitFunctionalMockStatement(FunctionalMockStatement functionalMockStatement) {
    }

    private static class SuiteMinimization
    implements Minimization {
        private final TestSuiteFitnessFunction fitness;
        private final TestSuiteChromosome suite;
        private final TestChromosome individual;
        private final int testIndex;
        private double lastFitness;
        private double lastCoverage;

        public SuiteMinimization(TestSuiteFitnessFunction fitness, TestSuiteChromosome suite, int index) {
            this.fitness = fitness;
            this.suite = suite;
            this.individual = (TestChromosome)suite.getTestChromosome(index);
            this.testIndex = index;
            this.lastFitness = suite.getFitness(fitness);
            this.lastCoverage = suite.getCoverage();
        }

        @Override
        public boolean isNotWorse() {
            ExecutionResult lastResult = this.individual.getLastExecutionResult().clone();
            this.individual.setChanged(true);
            this.suite.setTestChromosome(this.testIndex, this.individual);
            double newFitness = this.fitness.getFitness(this.suite);
            boolean worse = false;
            if (this.fitness.isMaximizationFunction()) {
                if (newFitness < this.lastFitness) {
                    worse = true;
                }
            } else if (newFitness > this.lastFitness) {
                worse = true;
            }
            if (!worse) {
                logger.debug("Fitness changed from " + this.lastFitness + " to " + newFitness);
                this.lastFitness = newFitness;
                this.lastCoverage = this.suite.getCoverage();
                this.suite.setFitness(this.fitness, this.lastFitness);
                return true;
            }
            this.individual.setLastExecutionResult(lastResult);
            this.suite.setFitness(this.fitness, this.lastFitness);
            this.suite.setCoverage(this.fitness, this.lastCoverage);
            return false;
        }
    }

    private static class TestMinimization
    implements Minimization {
        private final TestFitnessFunction fitness;
        private final TestChromosome individual;
        private double lastFitness;

        public TestMinimization(TestFitnessFunction fitness, TestChromosome test) {
            this.fitness = fitness;
            this.individual = test;
            this.lastFitness = test.getFitness(fitness);
        }

        @Override
        public boolean isNotWorse() {
            ExecutionResult lastResult = this.individual.getLastExecutionResult();
            this.individual.setChanged(true);
            this.individual.getTestCase().clearCoveredGoals();
            double newFitness = this.fitness.getFitness(this.individual);
            boolean worse = false;
            if (this.fitness.isMaximizationFunction()) {
                if (newFitness < this.lastFitness) {
                    worse = true;
                }
            } else if (newFitness > this.lastFitness) {
                worse = true;
            }
            if (!worse) {
                this.lastFitness = newFitness;
                this.individual.setFitness(this.fitness, this.lastFitness);
                return true;
            }
            this.individual.setFitness(this.fitness, this.lastFitness);
            this.individual.setLastExecutionResult(lastResult);
            return false;
        }
    }

    public static interface Minimization {
        public boolean isNotWorse();
    }
}

