/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.execution.reset;

import java.lang.reflect.Method;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.TimeController;
import org.evosuite.coverage.mutation.MutationObserver;
import org.evosuite.instrumentation.InstrumentingClassLoader;
import org.evosuite.runtime.LoopCounter;
import org.evosuite.runtime.Runtime;
import org.evosuite.runtime.classhandling.ClassResetter;
import org.evosuite.runtime.sandbox.Sandbox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClassReInitializeExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ClassReInitializeExecutor.class);
    private static final ClassReInitializeExecutor instance = new ClassReInitializeExecutor();

    private ClassReInitializeExecutor() {
    }

    public static synchronized ClassReInitializeExecutor getInstance() {
        return instance;
    }

    public void resetClasses(List<String> classesToReset) {
        InstrumentingClassLoader loader = TestGenerationContext.getInstance().getClassLoaderForSUT();
        this.resetClasses(classesToReset, loader);
    }

    public void resetClasses(List<String> classesToReset, ClassLoader loader) {
        ClassResetter.getInstance().setClassLoader(loader);
        long start = System.currentTimeMillis();
        for (String className : classesToReset) {
            long elapsed = System.currentTimeMillis() - start;
            if (className.equals(Properties.TARGET_CLASS) || !TimeController.getInstance().isThereStillTimeInThisPhase() || elapsed > (long)Properties.TIMEOUT_RESET) {
                // empty if block
            }
            this.resetClass(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetClass(String className) {
        logger.debug("Resetting class " + className);
        int mutationActive = MutationObserver.activeMutation;
        MutationObserver.deactivateMutation();
        Sandbox.goingToExecuteSUTCode();
        TestGenerationContext.getInstance().goingToExecuteSUTCode();
        Runtime.getInstance().resetRuntime();
        boolean wasLoopCheckOn = LoopCounter.getInstance().isActivated();
        try {
            Method resetMethod = ClassResetter.getInstance().getResetMethod(className);
            if (resetMethod != null) {
                LoopCounter.getInstance().setActive(false);
                resetMethod.invoke(null, (Object[])null);
            }
        }
        catch (Throwable e) {
            ClassResetter.getInstance().logWarn(className, e.getClass() + " thrown during execution of method  __STATIC_RESET() for class " + className + ", " + e.getCause());
        }
        finally {
            Sandbox.doneWithExecutingSUTCode();
            TestGenerationContext.getInstance().doneWithExecutingSUTCode();
            MutationObserver.activateMutation(mutationActive);
            LoopCounter.getInstance().setActive(wasLoopCheckOn);
        }
    }
}

