/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.execution.reset;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.assertion.CheapPurityAnalyzer;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.ExecutionTrace;
import org.evosuite.testcase.execution.reset.ClassReInitializeExecutor;
import org.evosuite.testcase.statements.AbstractStatement;
import org.evosuite.testcase.statements.FieldStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.statements.reflection.PrivateFieldStatement;
import org.evosuite.testcase.variable.FieldReference;
import org.evosuite.testcase.variable.VariableReference;

public class ClassReInitializer {
    private final List<String> initializedClasses = new LinkedList<String>();
    private static ClassReInitializer instance = null;
    private boolean reset_all_observed_classes = false;

    public static void resetSingleton() {
        instance = null;
    }

    public static ClassReInitializer getInstance() {
        if (instance == null) {
            instance = new ClassReInitializer();
        }
        return instance;
    }

    private ClassReInitializer() {
    }

    private static HashSet<String> getMoreClassesToReset(TestCase tc, ExecutionResult result) {
        HashSet<String> moreClassesForStaticReset = new HashSet<String>();
        block0: for (int position = 0; position < result.getExecutedStatements(); ++position) {
            AbstractStatement fieldStatement;
            Statement statement = tc.getStatement(position);
            if (Properties.RESET_STATIC_FIELD_GETS) {
                for (VariableReference var : statement.getVariableReferences()) {
                    if (!var.isFieldReference()) continue;
                    FieldReference fieldReference = (FieldReference)var;
                    moreClassesForStaticReset.add(fieldReference.getField().getOwnerClass().getClassName());
                }
            }
            if (statement.isAssignmentStatement()) {
                FieldReference fieldReference;
                if (!(statement.getReturnValue() instanceof FieldReference) || !(fieldReference = (FieldReference)statement.getReturnValue()).getField().isStatic()) continue;
                moreClassesForStaticReset.add(fieldReference.getField().getOwnerClass().getClassName());
                continue;
            }
            if (statement instanceof FieldStatement) {
                fieldStatement = (FieldStatement)statement;
                if (!((FieldStatement)fieldStatement).getField().isStatic()) continue;
                VariableReference fieldReference = fieldStatement.getReturnValue();
                if (Properties.RESET_STATIC_FIELD_GETS) {
                    moreClassesForStaticReset.add(((FieldStatement)fieldStatement).getField().getOwnerClass().getClassName());
                    continue;
                }
                for (int i = fieldStatement.getPosition() + 1; i < result.getExecutedStatements(); ++i) {
                    Statement invokedStatement = tc.getStatement(i);
                    if (!invokedStatement.references(fieldReference) || !(invokedStatement instanceof MethodStatement) || !fieldReference.equals(((MethodStatement)invokedStatement).getCallee()) || CheapPurityAnalyzer.getInstance().isPure(((MethodStatement)invokedStatement).getMethod().getMethod())) continue;
                    moreClassesForStaticReset.add(((FieldStatement)fieldStatement).getField().getOwnerClass().getClassName());
                    continue block0;
                }
                continue;
            }
            if (!(statement instanceof PrivateFieldStatement) || !((PrivateFieldStatement)(fieldStatement = (PrivateFieldStatement)statement)).isStaticField()) continue;
            moreClassesForStaticReset.add(((PrivateFieldStatement)fieldStatement).getOwnerClassName());
        }
        return moreClassesForStaticReset;
    }

    public void reInitializeClassesAfterTestExecution(TestCase executedTestCase, ExecutionResult testCaseResult) {
        ExecutionTrace trace = testCaseResult.getTrace();
        List<String> classesInitializedDuringTestExecution = trace.getInitializedClasses();
        this.addInitializedClasses(classesInitializedDuringTestExecution);
        if (this.initializedClasses.isEmpty()) {
            return;
        }
        if (this.reset_all_observed_classes) {
            ClassReInitializeExecutor.getInstance().resetClasses(this.initializedClasses);
        } else {
            DefaultTestCase defaultTestCase;
            ClassLoader changedClassLoader;
            LinkedList<String> classesToReset = new LinkedList<String>();
            classesToReset.addAll(trace.getClassesWithStaticWrites());
            if (Properties.RESET_STATIC_FIELD_GETS) {
                classesToReset.addAll(trace.getClassesWithStaticReads());
            }
            HashSet<String> moreClassesForReset = ClassReInitializer.getMoreClassesToReset(executedTestCase, testCaseResult);
            classesToReset.addAll(moreClassesForReset);
            Collections.sort(classesToReset);
            ClassLoader loader = null;
            if (executedTestCase instanceof DefaultTestCase && (changedClassLoader = (defaultTestCase = (DefaultTestCase)executedTestCase).getChangedClassLoader()) != null) {
                loader = changedClassLoader;
            }
            if (loader == null) {
                ClassReInitializeExecutor.getInstance().resetClasses(classesToReset);
            } else {
                ClassReInitializeExecutor.getInstance().resetClasses(classesToReset, loader);
            }
        }
    }

    public void setReInitializeAllClasses(boolean reInitializeAllClasses) {
        this.reset_all_observed_classes = reInitializeAllClasses;
    }

    private void addInitializedClass(String classNameWithDots) {
        if (!this.initializedClasses.contains(classNameWithDots)) {
            this.initializedClasses.add(classNameWithDots);
        }
    }

    public void addInitializedClasses(List<String> classNamesWithDots) {
        for (String classNameWithDots : classNamesWithDots) {
            this.addInitializedClass(classNameWithDots);
        }
    }

    public List<String> getInitializedClasses() {
        return new LinkedList<String>(this.initializedClasses);
    }
}

