/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.localsearch;

import org.evosuite.Properties;
import org.evosuite.ga.localsearch.LocalSearchBudget;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.localsearch.StatementLocalSearch;
import org.evosuite.testcase.localsearch.TestCaseLocalSearch;
import org.evosuite.testcase.statements.Statement;

public class AVMTestCaseLocalSearch
extends TestCaseLocalSearch {
    @Override
    public boolean doSearch(TestChromosome individual, LocalSearchObjective<TestChromosome> objective) {
        Integer lastPos;
        logger.info("Test before local search: " + individual.getTestCase().toCode());
        boolean improved = false;
        int lastPosition = individual.size() - 1;
        if (individual.getLastExecutionResult() != null && !individual.isChanged() && (lastPos = individual.getLastExecutionResult().getFirstPositionOfThrownException()) != null) {
            lastPosition = lastPos;
        }
        TestCase test = individual.getTestCase();
        for (int i = lastPosition; i >= 0 && !LocalSearchBudget.getInstance().isFinished() && !objective.isDone(); --i) {
            if (i >= individual.size()) {
                logger.warn("Test size decreased unexpectedly during local search, aborting local search");
                logger.warn(individual.getTestCase().toCode());
                break;
            }
            Class<?> targetClass = Properties.getTargetClassAndDontInitialise();
            Statement statement = test.getStatement(i);
            if (!test.hasReferences(statement.getReturnValue()) && !statement.getReturnClass().equals(targetClass)) {
                logger.info("Return value of statement " + i + " is not referenced and not SUT, not doing local search");
                continue;
            }
            StatementLocalSearch search = StatementLocalSearch.getLocalSearchFor(statement);
            if (search == null) continue;
            logger.info("Applying local search of type " + search.getClass() + " to statement " + statement + " / " + individual.getTestCase().getStatement(i));
            if (search.doSearch(individual, i, objective)) {
                improved = true;
            }
            logger.debug("Old position was: " + i + ", adjusting to: " + (i + search.getPositionDelta()));
            i += search.getPositionDelta();
            test = individual.getTestCase();
        }
        LocalSearchBudget.getInstance().countLocalSearchOnTest();
        return improved;
    }
}

