/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.mutation;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.evosuite.Properties;
import org.evosuite.setup.TestCluster;
import org.evosuite.testcase.ConstraintHelper;
import org.evosuite.testcase.ConstraintVerifier;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.mutation.InsertionStrategy;
import org.evosuite.testcase.statements.FunctionalMockStatement;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.variable.NullReference;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.ListUtil;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomInsertion
implements InsertionStrategy {
    private static final Logger logger = LoggerFactory.getLogger(RandomInsertion.class);

    @Override
    public int insertStatement(TestCase test, int lastPosition) {
        double r = Randomness.nextDouble();
        int oldSize = test.size();
        int max = lastPosition;
        if (max == test.size()) {
            ++max;
        }
        if (max <= 0) {
            max = 1;
        }
        int position = 0;
        assert (Properties.INSERTION_UUT + Properties.INSERTION_ENVIRONMENT + Properties.INSERTION_PARAMETER == 1.0);
        boolean insertUUT = Properties.INSERTION_UUT > 0.0 && r <= Properties.INSERTION_UUT && TestCluster.getInstance().getNumTestCalls() > 0;
        boolean insertEnv = !insertUUT && Properties.INSERTION_ENVIRONMENT > 0.0 && r > Properties.INSERTION_UUT && r <= Properties.INSERTION_UUT + Properties.INSERTION_ENVIRONMENT && TestCluster.getInstance().getNumOfEnvironmentCalls() > 0;
        boolean insertParam = !insertUUT && !insertEnv;
        boolean success = false;
        if (insertUUT) {
            position = test.size();
            success = TestFactory.getInstance().insertRandomCall(test, lastPosition + 1);
        } else if (insertEnv) {
            position = TestFactory.getInstance().insertRandomCallOnEnvironment(test, lastPosition);
            success = position >= 0;
        } else if (insertParam) {
            VariableReference var = this.selectRandomVariableForCall(test, lastPosition);
            if (var != null) {
                int lastUsage = var.getStPosition();
                for (VariableReference usage : test.getReferences(var)) {
                    if (usage.getStPosition() <= lastUsage) continue;
                    lastUsage = usage.getStPosition();
                }
                int boundPosition = ConstraintHelper.getLastPositionOfBounded(var, test);
                position = boundPosition >= 0 ? boundPosition + 1 : (lastUsage > var.getStPosition() + 1 ? Randomness.nextInt(var.getStPosition() + 1, lastUsage) : (lastUsage == var.getStPosition() ? lastUsage + 1 : lastUsage));
                if (logger.isDebugEnabled()) {
                    logger.debug("Inserting call at position " + position + ", chosen var: " + var.getName() + ", distance: " + var.getDistance() + ", class: " + var.getClassName());
                }
                success = TestFactory.getInstance().insertRandomCallOnObjectAt(test, var, position);
            }
            if (!success && TestCluster.getInstance().getNumTestCalls() > 0) {
                logger.debug("Adding new call on UUT because var was null");
                position = test.size();
                success = TestFactory.getInstance().insertRandomCall(test, position);
            }
        }
        if (test.size() - oldSize > 1) {
            position += test.size() - oldSize - 1;
        }
        if (success) {
            assert (ConstraintVerifier.verifyTest(test));
            assert (!ConstraintVerifier.hasAnyOnlyForAssertionMethod(test));
            return position;
        }
        return -1;
    }

    private VariableReference selectRandomVariableForCall(TestCase test, int position) {
        if (test.isEmpty() || position == 0) {
            return null;
        }
        List<VariableReference> allVariables = test.getObjects(position);
        List<Object> candidateVariables = new ArrayList();
        for (VariableReference var : allVariables) {
            if (var instanceof NullReference || var.isVoid() || var.getGenericClass().isObject() || test.getStatement(var.getStPosition()) instanceof PrimitiveStatement || var.isPrimitive() || !test.hasReferences(var) && !var.getVariableClass().equals(Properties.getInitializedTargetClass()) || test.getStatement(var.getStPosition()) instanceof FunctionalMockStatement) continue;
            candidateVariables.add(var);
        }
        if (candidateVariables.isEmpty()) {
            return null;
        }
        if (Properties.SORT_OBJECTS) {
            candidateVariables = candidateVariables.stream().sorted(Comparator.comparingInt(item -> item.getDistance())).collect(Collectors.toList());
            return (VariableReference)ListUtil.selectRankBiased(candidateVariables);
        }
        return (VariableReference)Randomness.choice(candidateVariables);
    }
}

