/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.statements.environment;

import java.lang.reflect.Type;
import org.evosuite.runtime.javaee.JeeData;
import org.evosuite.runtime.testdata.EvoName;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.statements.environment.EnvironmentDataStatement;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.Randomness;

public class NamePrimitiveStatement
extends EnvironmentDataStatement<EvoName> {
    public NamePrimitiveStatement(TestCase tc) {
        this(tc, (EvoName)null);
        this.randomize();
    }

    public NamePrimitiveStatement(TestCase tc, EvoName value) {
        super(tc, (Type)((Object)EvoName.class), value);
    }

    @Override
    public String getTestCode(String varName) {
        String testCode = "";
        VariableReference retval = this.getReturnValue();
        Object value = this.getValue();
        if (value != null) {
            String name = ((EvoName)value).getName();
            testCode = testCode + ((Class)retval.getType()).getSimpleName() + " " + varName + " = new " + ((Class)retval.getType()).getSimpleName() + "(\"" + name + "\");\n";
        } else {
            testCode = testCode + ((Class)retval.getType()).getSimpleName() + " " + varName + " = null;\n";
        }
        return testCode;
    }

    @Override
    public void delta() {
    }

    @Override
    public void zero() {
    }

    @Override
    public void randomize() {
        JeeData data = this.tc.getAccessedEnvironment().getJeeData();
        if (data == null) {
            this.setValue(null);
            return;
        }
        String name = (String)Randomness.choice(data.lookedUpContextNames);
        if (name != null) {
            this.setValue(new EvoName(name));
        } else {
            this.setValue(null);
        }
    }
}

