/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.statements.environment;

import java.lang.reflect.Type;
import org.evosuite.runtime.testdata.EvoSuiteURL;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.statements.environment.EnvironmentDataStatement;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.Randomness;
import org.evosuite.utils.StringUtil;

public class UrlPrimitiveStatement
extends EnvironmentDataStatement<EvoSuiteURL> {
    private static final long serialVersionUID = 2062390100066807026L;

    public UrlPrimitiveStatement(TestCase tc) {
        this(tc, (EvoSuiteURL)null);
        this.randomize();
    }

    public UrlPrimitiveStatement(TestCase tc, EvoSuiteURL value) {
        super(tc, (Type)((Object)EvoSuiteURL.class), value);
    }

    @Override
    public String getTestCode(String varName) {
        String testCode = "";
        VariableReference retval = this.getReturnValue();
        Object value = this.getValue();
        if (value != null) {
            String escapedURL = StringUtil.getEscapedString(((EvoSuiteURL)value).getUrl());
            testCode = testCode + ((Class)retval.getType()).getSimpleName() + " " + varName + " = new " + ((Class)retval.getType()).getSimpleName() + "(\"" + escapedURL + "\");\n";
        } else {
            testCode = testCode + ((Class)retval.getType()).getSimpleName() + " " + varName + " = null;\n";
        }
        return testCode;
    }

    @Override
    public void delta() {
        this.randomize();
    }

    @Override
    public void zero() {
    }

    @Override
    public void randomize() {
        String url = Randomness.choice(this.tc.getAccessedEnvironment().getViewOfRemoteURLs());
        if (url != null) {
            this.setValue(new EvoSuiteURL(url));
        } else {
            this.setValue(null);
        }
    }
}

