/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.statements.reflection;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.evosuite.runtime.PrivateAccess;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.ConstantValue;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.generic.GenericClass;
import org.evosuite.utils.generic.GenericMethod;

public class PrivateMethodStatement
extends MethodStatement {
    private static final long serialVersionUID = -4555899888145880432L;
    private GenericMethod reflectedMethod;
    private boolean isStaticMethod = false;

    public PrivateMethodStatement(TestCase tc, Class<?> klass, Method method, VariableReference callee, List<VariableReference> params, boolean isStatic) {
        super(tc, new GenericMethod(PrivateAccess.getCallMethod((int)params.size()), PrivateAccess.class), null, PrivateMethodStatement.getReflectionParams(tc, klass, method, callee, params));
        this.reflectedMethod = new GenericMethod(method, klass);
        this.isStaticMethod = isStatic;
        ArrayList<GenericClass> parameterTypes = new ArrayList<GenericClass>();
        parameterTypes.add(new GenericClass(klass));
        this.method.setTypeParameters(parameterTypes);
    }

    private static List<VariableReference> getReflectionParams(TestCase tc, Class<?> klass, Method method, VariableReference callee, List<VariableReference> inputs) {
        ArrayList<VariableReference> list = new ArrayList<VariableReference>(3 + inputs.size() * 2);
        list.add(new ConstantValue(tc, new GenericClass(Class.class), klass));
        list.add(callee);
        list.add(new ConstantValue(tc, new GenericClass(String.class), method.getName()));
        Class<?>[] parameterTypes = method.getParameterTypes();
        assert (parameterTypes.length == inputs.size());
        for (int parameterNum = 0; parameterNum < parameterTypes.length; ++parameterNum) {
            VariableReference vr = inputs.get(parameterNum);
            list.add(vr);
            list.add(new ConstantValue(tc, new GenericClass(Class.class), parameterTypes[parameterNum]));
        }
        return list;
    }

    @Override
    public boolean mutate(TestCase test, TestFactory factory) {
        return false;
    }

    @Override
    public Statement copy(TestCase newTestCase, int offset) {
        ArrayList<VariableReference> newParams = new ArrayList<VariableReference>();
        for (int i = 3; i < this.parameters.size(); i += 2) {
            newParams.add(((VariableReference)this.parameters.get(i)).copy(newTestCase, offset));
        }
        VariableReference newCallee = ((VariableReference)this.parameters.get(1)).copy(newTestCase, offset);
        Class klass = (Class)((ConstantValue)this.parameters.get(0)).getValue();
        PrivateMethodStatement pm = new PrivateMethodStatement(newTestCase, klass, this.reflectedMethod.getMethod(), newCallee, newParams, this.isStaticMethod);
        assert (pm.parameters.size() == this.parameters.size());
        return pm;
    }

    @Override
    public Throwable execute(Scope scope, PrintStream out) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException, InstantiationException {
        if (!this.isStaticMethod) {
            VariableReference callee = (VariableReference)this.parameters.get(1);
            try {
                Object calleeObject = callee.getObject(scope);
                if (calleeObject == null) {
                    return new CodeUnderTestException(new NullPointerException());
                }
            }
            catch (CodeUnderTestException e) {
                return e;
            }
        }
        return super.execute(scope, out);
    }

    @Override
    public boolean isReflectionStatement() {
        return true;
    }
}

