/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.statements.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.runtime.Reflection;
import org.evosuite.runtime.javaee.injection.Injector;
import org.evosuite.utils.Randomness;

public class ReflectionFactory {
    private final Class<?> target;
    private final List<Field> fields;
    private final List<Method> methods;

    public ReflectionFactory(Class<?> target) throws IllegalArgumentException {
        this.target = target;
        if (target == null) {
            throw new IllegalArgumentException("Target class cannot be null");
        }
        this.fields = new ArrayList<Field>();
        this.methods = new ArrayList<Method>();
        for (Method m : Reflection.getDeclaredMethods(target)) {
            if (!Modifier.isPrivate(m.getModifiers()) || m.isBridge() || m.isSynthetic()) continue;
            this.methods.add(m);
        }
        List toSkip = null;
        if (Properties.JEE) {
            toSkip = Injector.getAllFieldsToInject(target);
        }
        for (Field f : Reflection.getDeclaredFields(target)) {
            if (!Modifier.isPrivate(f.getModifiers()) || f.isSynthetic() || toSkip != null && toSkip.contains(f) || f.getName().equals("serialVersionUID") || f.getName().equals("writeObject") || f.getName().equals("readObject") || Modifier.isFinal(f.getModifiers()) && f.getType().isPrimitive() || Modifier.isFinal(f.getModifiers()) && f.getType().equals(String.class) || Modifier.isStatic(f.getModifiers())) continue;
            this.fields.add(f);
        }
    }

    public int getNumberOfUsableFields() {
        return this.fields.size();
    }

    public boolean hasPrivateFieldsOrMethods() {
        return !this.fields.isEmpty() || !this.methods.isEmpty();
    }

    public boolean nextUseField() {
        if (this.fields.isEmpty()) {
            return false;
        }
        if (this.methods.isEmpty()) {
            assert (!this.fields.isEmpty());
            return true;
        }
        assert (!this.fields.isEmpty() && !this.methods.isEmpty());
        int tot = this.fields.size() + this.methods.size();
        double ratio = (double)this.fields.size() / (double)tot;
        return Randomness.nextDouble() <= ratio;
    }

    public Field nextField() throws IllegalStateException {
        if (this.fields.isEmpty()) {
            throw new IllegalStateException("No private field");
        }
        return Randomness.choice(this.fields);
    }

    public Method nextMethod() throws IllegalStateException {
        if (this.methods.isEmpty()) {
            throw new IllegalStateException("No private method");
        }
        return Randomness.choice(this.methods);
    }

    public Class<?> getReflectedClass() {
        return this.target;
    }
}

