/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testsuite;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import org.evosuite.TestGenerationContext;
import org.evosuite.runtime.util.Inputs;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.DebuggingObjectOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSuiteSerialization {
    private static final Logger logger = LoggerFactory.getLogger(TestSuiteSerialization.class);

    public static boolean saveTests(List<TestSuiteChromosome> list, File target) throws IllegalArgumentException {
        Inputs.checkNull((Object[])new Object[]{list, target});
        File parent = target.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        try (DebuggingObjectOutputStream out = new DebuggingObjectOutputStream(new FileOutputStream(target));){
            for (TestSuiteChromosome ts : list) {
                for (TestChromosome tc : ts.getTestChromosomes()) {
                    out.writeObject(tc);
                }
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            logger.error("Failed to open/handle " + target.getAbsolutePath() + " for writing: " + e.getMessage());
            return false;
        }
        return true;
    }

    public static boolean saveTests(TestSuiteChromosome ts, File target) throws IllegalArgumentException {
        File parent = target.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        try (DebuggingObjectOutputStream out = new DebuggingObjectOutputStream(new FileOutputStream(target));){
            for (TestChromosome tc : ts.getTestChromosomes()) {
                out.writeObject(tc);
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            logger.error("Failed to open/handle " + target.getAbsolutePath() + " for writing: " + e.getMessage());
            return false;
        }
        return true;
    }

    public static boolean saveTests(List<TestSuiteChromosome> ts, File folder, String fileName) throws IllegalArgumentException {
        Inputs.checkNull((Object[])new Object[]{ts, folder, fileName});
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File target = new File(folder, fileName);
        return TestSuiteSerialization.saveTests(ts, target);
    }

    public static List<TestChromosome> loadTests(File folder, String fileName) throws IllegalArgumentException {
        Inputs.checkNull((Object[])new Object[]{folder, fileName});
        File target = new File(folder, fileName);
        return TestSuiteSerialization.loadTests(target);
    }

    public static List<TestChromosome> loadTests(String target) throws IllegalArgumentException {
        return TestSuiteSerialization.loadTests(new File(target));
    }

    public static List<TestChromosome> loadTests(File target) throws IllegalArgumentException {
        Inputs.checkNull((Object[])new Object[]{target});
        ArrayList<TestChromosome> list = new ArrayList<TestChromosome>();
        try (ObjectInputStream in = new ObjectInputStream(new FileInputStream(target));){
            try {
                Object obj = in.readObject();
                while (obj != null) {
                    if (obj instanceof TestChromosome) {
                        TestChromosome tc = (TestChromosome)obj;
                        for (Statement st : tc.getTestCase()) {
                            st.changeClassLoader(TestGenerationContext.getInstance().getClassLoaderForSUT());
                        }
                        list.add(tc);
                    }
                    obj = in.readObject();
                }
            }
            catch (EOFException obj) {
            }
            catch (Exception e) {
                logger.warn("Problems when reading a serialized test from " + target.getAbsolutePath() + " : " + e.getMessage());
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            logger.warn("Cannot load tests because file does not exist: " + target.getAbsolutePath());
        }
        catch (IOException e) {
            logger.error("Failed to open/handle " + target.getAbsolutePath() + " for reading: " + e.getMessage());
        }
        return list;
    }
}

