/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testsuite.secondaryobjectives;

import org.evosuite.ga.SecondaryObjective;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;

public class MinimizeMaxLengthSecondaryObjective
extends SecondaryObjective<TestSuiteChromosome> {
    private static final long serialVersionUID = 2270058273932360617L;

    private int getMaxLength(TestSuiteChromosome chromosome) {
        int max = 0;
        for (ExecutableChromosome test : chromosome.getTestChromosomes()) {
            max = Math.max(max, test.size());
        }
        return max;
    }

    @Override
    public int compareChromosomes(TestSuiteChromosome chromosome1, TestSuiteChromosome chromosome2) {
        return this.getMaxLength(chromosome1) - this.getMaxLength(chromosome2);
    }

    @Override
    public int compareGenerations(TestSuiteChromosome parent1, TestSuiteChromosome parent2, TestSuiteChromosome child1, TestSuiteChromosome child2) {
        return Math.min(this.getMaxLength(parent1), this.getMaxLength(parent2)) - Math.min(this.getMaxLength(child1), this.getMaxLength(child2));
    }
}

