/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testsuite.similarity;

import java.util.List;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.SearchListener;
import org.evosuite.rmi.ClientServices;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.FieldStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiversityObserver
implements SearchListener {
    private static final Logger logger = LoggerFactory.getLogger(DiversityObserver.class);
    public static final int GAP_PENALTY = -2;

    @Override
    public void iteration(GeneticAlgorithm<?> algorithm) {
        List<?> individuals = algorithm.getPopulation();
        double diversity = 0.0;
        int numComparisons = 0;
        for (int i = 0; i < individuals.size() - 1; ++i) {
            for (int j = i + 1; j < individuals.size(); ++j) {
                double pairDiversity = DiversityObserver.getSuiteSimilarity((TestSuiteChromosome)individuals.get(i), (TestSuiteChromosome)individuals.get(j));
                logger.debug("Adding diversity of pair " + i + ", " + j + " of " + pairDiversity);
                diversity += pairDiversity;
                ++numComparisons;
            }
        }
        diversity = 1.0 - diversity / (double)numComparisons;
        logger.info("Resulting diversity for " + numComparisons + " pairs: " + diversity);
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.DiversityTimeline, diversity);
    }

    public static double getSuiteSimilarity(TestSuiteChromosome suite1, TestSuiteChromosome suite2) {
        DefaultTestCase test1 = new DefaultTestCase();
        for (TestCase test : suite1.getTests()) {
            for (Statement s : test) {
                test1.addStatement(s);
            }
        }
        DefaultTestCase test2 = new DefaultTestCase();
        for (TestCase test : suite2.getTests()) {
            for (Statement s : test) {
                test2.addStatement(s);
            }
        }
        return DiversityObserver.getNeedlemanWunschScore(test1, test2);
    }

    public static double getNeedlemanWunschScore(TestCase test1, TestCase test2) {
        int i;
        int[][] matrix = new int[test1.size() + 1][test2.size() + 1];
        for (i = 0; i <= test1.size(); ++i) {
            matrix[i][0] = -2 * i;
        }
        for (i = 0; i <= test2.size(); ++i) {
            matrix[0][i] = -2 * i;
        }
        for (int x = 1; x <= test1.size(); ++x) {
            for (int y = 1; y <= test2.size(); ++y) {
                int upLeft = matrix[x - 1][y - 1] + DiversityObserver.getStatementSimilarity(test1.getStatement(x - 1), test2.getStatement(y - 1));
                int insert = matrix[x - 1][y] + -2;
                int delete = matrix[x][y - 1] + -2;
                matrix[x][y] = Math.max(upLeft, Math.max(delete, insert));
            }
        }
        double max = Math.max(test1.size(), test2.size()) * Math.abs(-2);
        if (max == 0.0) {
            return 0.0;
        }
        return (double)matrix[test1.size()][test2.size()] / max;
    }

    private static int getStatementSimilarity(Statement s1, Statement s2) {
        int similarity = 0;
        if (s1.getClass() == s2.getClass()) {
            ++similarity;
            if (s1 instanceof ConstructorStatement) {
                if (DiversityObserver.getUnderlyingType((ConstructorStatement)s1).equals(DiversityObserver.getUnderlyingType((ConstructorStatement)s2))) {
                    ++similarity;
                }
            } else if (s1 instanceof PrimitiveStatement) {
                if (DiversityObserver.getUnderlyingType((PrimitiveStatement)s1).equals(DiversityObserver.getUnderlyingType((PrimitiveStatement)s2))) {
                    ++similarity;
                }
            } else if (s1 instanceof MethodStatement) {
                if (DiversityObserver.getUnderlyingType((MethodStatement)s1).equals(DiversityObserver.getUnderlyingType((MethodStatement)s2))) {
                    ++similarity;
                }
            } else if (s1 instanceof FieldStatement && DiversityObserver.getUnderlyingType((FieldStatement)s1).equals(DiversityObserver.getUnderlyingType((FieldStatement)s2))) {
                ++similarity;
            }
        } else {
            similarity = -2;
        }
        return similarity;
    }

    private static Class<?> getUnderlyingType(ConstructorStatement cs) {
        return cs.getReturnClass();
    }

    private static Class<?> getUnderlyingType(MethodStatement ms) {
        return ms.getMethod().getDeclaringClass();
    }

    private static Class<?> getUnderlyingType(FieldStatement fs) {
        return fs.getField().getDeclaringClass();
    }

    private static Class<?> getUnderlyingType(PrimitiveStatement ps) {
        return ps.getReturnClass();
    }

    public static void printMatrix(int[][] matrix) {
        for (int x = 0; x < matrix.length; ++x) {
            for (int y = 0; y < matrix[x].length; ++y) {
                System.out.print(" " + matrix[x][y]);
            }
            System.out.println();
        }
    }

    @Override
    public void searchStarted(GeneticAlgorithm<?> algorithm) {
    }

    @Override
    public void searchFinished(GeneticAlgorithm<?> algorithm) {
    }

    @Override
    public void fitnessEvaluation(Chromosome individual) {
    }

    @Override
    public void modification(Chromosome individual) {
    }
}

