/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.evosuite.Properties;
import org.evosuite.utils.FileIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlAnalyzer
implements Serializable {
    private static final long serialVersionUID = -5634296119340294425L;
    private static final Logger logger = LoggerFactory.getLogger(HtmlAnalyzer.class);
    private Set<File> files;

    public Iterable<String> getClassContent(String fullClassName) {
        if (this.files == null) {
            this.initFiles();
        }
        String className = this.getClassName(fullClassName);
        logger.debug("Looking for content of class " + fullClassName + " in " + this.files.size() + " files.");
        logger.debug("Files: " + this.files);
        for (File f : this.files) {
            String name = HtmlAnalyzer.getContainingClassName(f);
            if (!name.endsWith(className) || name.endsWith("Test" + className)) continue;
            List<String> linesFromFile = FileIOUtils.readFile(f);
            logger.debug("Got file " + f + "for class " + fullClassName);
            return linesFromFile;
        }
        String msg = "No source found for " + fullClassName;
        logger.debug(msg);
        return Arrays.asList(msg);
    }

    public static String getContainingClassName(File f) {
        int j;
        int i;
        String name = f.getAbsolutePath();
        String sep = System.getProperty("file.separator");
        if ((name = name.replace(sep, ".")).endsWith(".java")) {
            name = name.substring(0, name.length() - 5);
        }
        if ((i = name.lastIndexOf(Properties.PROJECT_PREFIX)) <= (j = name.lastIndexOf(sep))) {
            name = i < 0 ? "" : name.substring(i);
        }
        return name;
    }

    private void initFiles() {
        File startDirectory = new File(".");
        String[] extensions = new String[]{"java"};
        Collection javaFiles = FileUtils.listFiles((File)startDirectory, (String[])extensions, (boolean)true);
        this.files = new HashSet<File>(javaFiles);
    }

    private String getClassName(String name) {
        if (name.contains("$")) {
            name = name.substring(0, name.indexOf(36));
        }
        return name;
    }
}

