/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.evosuite.utils.Listener;
import org.evosuite.utils.SimpleListenable;

public class ListenableList<E>
extends SimpleListenable<Void>
implements List<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Listener<Void> listener = new Listener<Void>(){
        private static final long serialVersionUID = 1L;

        @Override
        public void receiveEvent(Void event) {
            ListenableList.this.fireEvent(null);
        }
    };
    private final List<E> delegate;

    public ListenableList(List<E> delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean add(E e) {
        boolean result = this.delegate.add(e);
        this.fireEvent(null);
        return result;
    }

    @Override
    public void add(int index, E element) {
        this.delegate.add(index, element);
        this.fireEvent(null);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean result = this.delegate.addAll(c);
        this.fireEvent(null);
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean result = this.delegate.addAll(index, c);
        this.fireEvent(null);
        return result;
    }

    @Override
    public void clear() {
        this.delegate.clear();
        this.fireEvent(null);
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public E get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        ObservableListIterator<E> result = new ObservableListIterator<E>(this.delegate.listIterator());
        result.addListener(this.listener);
        return result;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        ObservableListIterator<E> result = new ObservableListIterator<E>(this.delegate.listIterator(index));
        result.addListener(this.listener);
        return result;
    }

    @Override
    public E remove(int index) {
        E result = this.delegate.remove(index);
        this.fireEvent(null);
        return result;
    }

    @Override
    public boolean remove(Object o) {
        boolean result = this.delegate.remove(o);
        this.fireEvent(null);
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = this.delegate.removeAll(c);
        this.fireEvent(null);
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean result = this.delegate.retainAll(c);
        this.fireEvent(null);
        return result;
    }

    @Override
    public E set(int index, E element) {
        E result = this.delegate.set(index, element);
        this.fireEvent(null);
        return result;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        ListenableList<E> result = new ListenableList<E>(this.delegate.subList(fromIndex, toIndex));
        result.addListener(this.listener);
        return result;
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    private static class ObservableListIterator<E>
    extends SimpleListenable<Void>
    implements ListIterator<E> {
        private static final long serialVersionUID = 1L;
        private final ListIterator<E> delegate;

        public ObservableListIterator(ListIterator<E> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void add(E e) {
            this.delegate.add(e);
            this.fireEvent(null);
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.delegate.hasPrevious();
        }

        @Override
        public E next() {
            return this.delegate.next();
        }

        @Override
        public int nextIndex() {
            return this.delegate.nextIndex();
        }

        @Override
        public E previous() {
            return this.delegate.previous();
        }

        @Override
        public int previousIndex() {
            return this.delegate.previousIndex();
        }

        @Override
        public void remove() {
            this.delegate.remove();
            this.fireEvent(null);
        }

        @Override
        public void set(E e) {
            this.delegate.set(e);
            this.fireEvent(null);
        }
    }
}

