/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpawnProcessKeepAliveChecker {
    private static final Logger logger = LoggerFactory.getLogger(SpawnProcessKeepAliveChecker.class);
    private static final SpawnProcessKeepAliveChecker instance = new SpawnProcessKeepAliveChecker();
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    private static final String STILL_ALIVE = "still_alive";
    private static final int DELTA_MS = 5000;
    private volatile ServerSocket server;
    private volatile Thread serverThread;
    private volatile Thread clientThread;

    public static SpawnProcessKeepAliveChecker getInstance() {
        return instance;
    }

    public int startServer() throws IllegalStateException {
        if (this.server != null || this.serverThread != null) {
            throw new IllegalStateException("Recorder already running");
        }
        try {
            this.server = new ServerSocket(0, -1, InetAddress.getLoopbackAddress());
        }
        catch (IOException e) {
            return -1;
        }
        this.serverThread = new Thread(){

            @Override
            public void run() {
                while (!this.isInterrupted() && SpawnProcessKeepAliveChecker.this.server != null && !SpawnProcessKeepAliveChecker.this.server.isClosed()) {
                    try {
                        Socket socket = SpawnProcessKeepAliveChecker.this.server.accept();
                        socket.setKeepAlive(true);
                        executor.submit(new KeepAliveTask(socket));
                        logger.info("Registered remote process from " + socket.getRemoteSocketAddress());
                    }
                    catch (IOException e) {
                        return;
                    }
                }
            }
        };
        this.serverThread.start();
        int port = this.server.getLocalPort();
        logger.info("Started spawn process manager on port {}", (Object)port);
        return port;
    }

    public void stopServer() {
        logger.info("Stopping spawn process manager");
        try {
            if (this.server != null) {
                this.server.close();
                this.server = null;
            }
        }
        catch (IOException e) {
            logger.error(e.toString());
        }
        if (this.serverThread != null) {
            this.serverThread.interrupt();
            this.serverThread = null;
        }
    }

    public void registerToRemoteServerAndDieIfFails(final int port) throws IllegalStateException {
        if (this.clientThread != null) {
            throw new IllegalStateException("Already registered");
        }
        this.clientThread = new Thread(){

            @Override
            public void run() {
                boolean failed = false;
                try {
                    Socket socket = new Socket(InetAddress.getLoopbackAddress(), port);
                    Scanner in = new Scanner(socket.getInputStream());
                    2.sleep(5000L);
                    while (!this.isInterrupted()) {
                        if (!in.hasNext()) {
                            failed = true;
                            break;
                        }
                        in.nextLine();
                        2.sleep(5000L);
                    }
                }
                catch (IOException e) {
                    failed = true;
                }
                catch (InterruptedException e) {
                    failed = false;
                }
                if (failed) {
                    logger.error("Failed to receive keep alive message. Going to shutdown the process.");
                    try {
                        2.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.exit(1);
                }
            }
        };
        this.clientThread.start();
    }

    public void unRegister() {
        if (this.clientThread != null) {
            this.clientThread.interrupt();
            this.clientThread = null;
        }
    }

    private static class KeepAliveTask
    implements Runnable {
        private final Socket socket;

        public KeepAliveTask(Socket s) {
            this.socket = s;
        }

        @Override
        public void run() {
            try {
                PrintWriter out = new PrintWriter(this.socket.getOutputStream());
                while (this.socket.isConnected()) {
                    out.println(SpawnProcessKeepAliveChecker.STILL_ALIVE);
                    Thread.sleep(5000L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

