/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.evosuite.runtime.InitializingListenerUtils;

@Mojo(name="prepare")
public class PrepareMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Preparing EvoSuite tests for execution");
        String dirName = this.project.getBuild().getTestOutputDirectory();
        if (dirName == null || dirName.trim().isEmpty()) {
            this.getLog().error((CharSequence)"Cannot determine folder for compiled tests");
            return;
        }
        File dir = new File(dirName);
        this.getLog().info((CharSequence)("Analyzing test folder: " + dir.getAbsolutePath()));
        if (!dir.exists()) {
            this.getLog().warn((CharSequence)("Target folder for compiled tests does not exist: " + dir.getAbsolutePath()));
            return;
        }
        List list = InitializingListenerUtils.scanClassesToInit((File)dir);
        this.getLog().info((CharSequence)("Found " + list.size() + " EvoSuite scaffolding files"));
        File scaffolding = new File(this.project.getBasedir() + File.separator + ".scaffolding_list.tmp");
        try {
            PrintWriter out = new PrintWriter(scaffolding);
            for (String s : list) {
                out.println(s);
                this.getLog().debug((CharSequence)("Class: " + s));
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            this.getLog().error((CharSequence)("Error while generating " + scaffolding.getAbsolutePath() + " : " + e.getMessage()));
        }
    }
}

