/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.maven.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.utils.MD5;

public class HistoryChanges {
    public static void keepTrack(String basedir, List<File> files) throws Exception {
        File dot_evosuite = new File(basedir + File.separator + Properties.CTG_DIR);
        if (!dot_evosuite.exists() && !dot_evosuite.mkdir()) {
            throw new Exception("No permission to create the directory '" + basedir + File.separator + Properties.CTG_DIR + "'");
        }
        File hash_file = new File(basedir + File.separator + Properties.CTG_DIR + File.separator + "hash_file");
        File history_file = new File(basedir + File.separator + Properties.CTG_DIR + File.separator + "history_file");
        if (!hash_file.exists()) {
            try {
                if (!hash_file.createNewFile()) {
                    throw new Exception("No permission to create the file '" + basedir + File.separator + Properties.CTG_DIR + File.separator + "hash_file'");
                }
                if (!history_file.createNewFile()) {
                    throw new Exception("No permission to create the file '" + basedir + File.separator + Properties.CTG_DIR + File.separator + "history_file'");
                }
                FileWriter hash_file_fw = new FileWriter(hash_file.getAbsoluteFile());
                BufferedWriter hash_file_bw = new BufferedWriter(hash_file_fw);
                FileWriter history_file_fw = new FileWriter(history_file.getAbsoluteFile());
                BufferedWriter history_file_bw = new BufferedWriter(history_file_fw);
                for (File file : files) {
                    hash_file_bw.write(file.getAbsolutePath() + "\t" + MD5.hash((File)file) + "\n");
                    history_file_bw.write("A\t" + file.getAbsolutePath() + "\n");
                }
                hash_file_bw.close();
                history_file_bw.close();
            }
            catch (IOException e) {
                throw new Exception("IOException: ", e);
            }
        }
        LinkedHashMap<String, String> hash_file_content = new LinkedHashMap<String, String>();
        try (BufferedReader br = new BufferedReader(new FileReader(hash_file));){
            String sCurrentLine;
            while ((sCurrentLine = br.readLine()) != null) {
                String[] split = sCurrentLine.split("\t");
                hash_file_content.put(split[0], split[1]);
            }
        }
        catch (IOException e) {
            throw new Exception("reading the content of hash_file ", e);
        }
        try {
            FileWriter hash_file_fw = new FileWriter(hash_file.getAbsoluteFile());
            BufferedWriter hash_file_bw = new BufferedWriter(hash_file_fw);
            hash_file_bw.write("");
            FileWriter history_file_fw = new FileWriter(history_file.getAbsoluteFile());
            BufferedWriter history_file_bw = new BufferedWriter(history_file_fw);
            history_file_bw.write("");
            for (File file : files) {
                String hash = MD5.hash((File)file);
                hash_file_bw.write(file.getAbsolutePath() + "\t" + hash + "\n");
                if (!hash_file_content.containsKey(file.getAbsolutePath())) {
                    history_file_bw.write("A\t" + file.getAbsolutePath() + "\n");
                    continue;
                }
                if (((String)hash_file_content.get(file.getAbsolutePath())).equals(hash)) continue;
                history_file_bw.write("M\t" + file.getAbsolutePath() + "\n");
            }
            hash_file_bw.close();
            history_file_bw.close();
        }
        catch (IOException e) {
            throw new Exception("IOException: ", e);
        }
    }
}

