/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.impl.cmd;

import java.util.Collection;
import java.util.List;
import org.flowable.app.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.variable.service.VariableService;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class RemoveVariablesCmd
implements Command<Void> {
    protected String appDefinitionId;
    protected Collection<String> variableNames;

    public RemoveVariablesCmd(String appDefinitionId, Collection<String> variableNames) {
        this.appDefinitionId = appDefinitionId;
        this.variableNames = variableNames;
    }

    public Void execute(CommandContext commandContext) {
        if (this.appDefinitionId == null) {
            throw new FlowableIllegalArgumentException("appDefinitionId is null");
        }
        if (this.variableNames == null) {
            throw new FlowableIllegalArgumentException("variableNames is null");
        }
        VariableService variableService = CommandContextUtil.getVariableService(commandContext);
        List variableInstances = variableService.findVariableInstanceByScopeIdAndScopeType(this.appDefinitionId, "app");
        if (variableInstances != null && variableInstances.size() > 0) {
            for (VariableInstanceEntity variableInstanceEntity : variableInstances) {
                if (!this.variableNames.contains(variableInstanceEntity.getName())) continue;
                variableService.deleteVariableInstance(variableInstanceEntity);
            }
        }
        return null;
    }
}

