/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.batch.service;

import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.api.BatchPartBuilder;
import org.flowable.batch.service.BatchServiceConfiguration;
import org.flowable.batch.service.impl.persistence.entity.BatchPartEntity;
import org.flowable.batch.service.impl.persistence.entity.BatchPartEntityManager;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;

public class BatchPartBuilderImpl
implements BatchPartBuilder {
    protected final Batch batch;
    protected final BatchServiceConfiguration batchServiceConfiguration;
    protected final CommandExecutor commandExecutor;
    protected String type;
    protected String searchKey;
    protected String searchKey2;
    protected String status;
    protected String scopeId;
    protected String subScopeId;
    protected String scopeType;

    public BatchPartBuilderImpl(Batch batch, BatchServiceConfiguration batchServiceConfiguration) {
        this(batch, batchServiceConfiguration, null);
    }

    public BatchPartBuilderImpl(Batch batch, BatchServiceConfiguration batchServiceConfiguration, CommandExecutor commandExecutor) {
        this.batch = batch;
        this.commandExecutor = commandExecutor;
        this.batchServiceConfiguration = batchServiceConfiguration;
    }

    public BatchPartBuilder type(String type) {
        if (type == null) {
            throw new FlowableIllegalArgumentException("type is null");
        }
        this.type = type;
        return this;
    }

    public BatchPartBuilder searchKey(String searchKey) {
        this.searchKey = searchKey;
        return this;
    }

    public BatchPartBuilder searchKey2(String searchKey2) {
        this.searchKey2 = searchKey2;
        return this;
    }

    public BatchPartBuilder status(String status) {
        if (status == null) {
            throw new FlowableIllegalArgumentException("status is null");
        }
        this.status = status;
        return this;
    }

    public BatchPartBuilder scopeId(String scopeId) {
        if (scopeId == null) {
            throw new FlowableIllegalArgumentException("scopeId is null");
        }
        this.scopeId = scopeId;
        return this;
    }

    public BatchPartBuilder subScopeId(String subScopeId) {
        if (subScopeId == null) {
            throw new FlowableIllegalArgumentException("subScopeId is null");
        }
        this.subScopeId = subScopeId;
        return this;
    }

    public BatchPartBuilder scopeType(String scopeType) {
        if (scopeType == null) {
            throw new FlowableIllegalArgumentException("scopeType is null");
        }
        this.scopeType = scopeType;
        return this;
    }

    public BatchPart create() {
        if (this.batch == null) {
            throw new FlowableIllegalArgumentException("batch has to be provided");
        }
        if (this.type == null) {
            throw new FlowableIllegalArgumentException("type has to be provided");
        }
        if (this.commandExecutor != null) {
            return (BatchPart)this.commandExecutor.execute(commandContext -> this.createSafe());
        }
        return this.createSafe();
    }

    protected BatchPart createSafe() {
        BatchPartEntityManager partEntityManager = this.batchServiceConfiguration.getBatchPartEntityManager();
        BatchPartEntity batchPart = (BatchPartEntity)partEntityManager.create();
        batchPart.setBatchId(this.batch.getId());
        batchPart.setBatchType(this.batch.getBatchType());
        batchPart.setBatchSearchKey(this.batch.getBatchSearchKey());
        batchPart.setBatchSearchKey2(this.batch.getBatchSearchKey2());
        if (this.batch.getTenantId() != null) {
            batchPart.setTenantId(this.batch.getTenantId());
        }
        batchPart.setType(this.type);
        batchPart.setSearchKey(this.searchKey);
        batchPart.setSearchKey2(this.searchKey2);
        batchPart.setStatus(this.status);
        batchPart.setScopeId(this.scopeId);
        batchPart.setSubScopeId(this.subScopeId);
        batchPart.setScopeType(this.scopeType);
        batchPart.setCreateTime(this.batchServiceConfiguration.getClock().getCurrentTime());
        partEntityManager.insert(batchPart);
        return batchPart;
    }
}

