/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter;

import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.CaseElementXmlConverter;
import org.flowable.cmmn.converter.ConversionHelper;
import org.flowable.cmmn.converter.exception.XMLException;
import org.flowable.cmmn.converter.util.CmmnXmlUtil;
import org.flowable.cmmn.converter.util.ListenerXmlConverterUtil;
import org.flowable.cmmn.model.AbstractFlowableHttpHandler;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.ChildTask;
import org.flowable.cmmn.model.CmmnElement;
import org.flowable.cmmn.model.CompletionNeutralRule;
import org.flowable.cmmn.model.DecisionTask;
import org.flowable.cmmn.model.ExtensionElement;
import org.flowable.cmmn.model.FieldExtension;
import org.flowable.cmmn.model.FlowableHttpRequestHandler;
import org.flowable.cmmn.model.FlowableHttpResponseHandler;
import org.flowable.cmmn.model.FlowableListener;
import org.flowable.cmmn.model.GenericEventListener;
import org.flowable.cmmn.model.HasLifecycleListeners;
import org.flowable.cmmn.model.HttpServiceTask;
import org.flowable.cmmn.model.HumanTask;
import org.flowable.cmmn.model.IOParameter;
import org.flowable.cmmn.model.ParentCompletionRule;
import org.flowable.cmmn.model.PlanItemControl;
import org.flowable.cmmn.model.SendEventServiceTask;
import org.flowable.cmmn.model.ServiceTask;
import org.flowable.common.engine.api.FlowableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionElementsXMLConverter
extends CaseElementXmlConverter {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ExtensionElementsXMLConverter.class);

    @Override
    public String getXMLElementName() {
        return "extensionElements";
    }

    @Override
    public boolean hasChildElements() {
        return false;
    }

    protected CmmnElement convert(XMLStreamReader xtr, ConversionHelper conversionHelper) {
        boolean readyWithChildElements = false;
        try {
            while (!readyWithChildElements && xtr.hasNext()) {
                xtr.next();
                if (xtr.isStartElement()) {
                    if ("completionNeutralRule".equals(xtr.getLocalName())) {
                        this.readCompletionNeutralRule(xtr, conversionHelper);
                        continue;
                    }
                    if ("parentCompletionRule".equals(xtr.getLocalName())) {
                        this.readParentCompletionRule(xtr, conversionHelper);
                        continue;
                    }
                    if ("field".equals(xtr.getLocalName())) {
                        this.readFieldExtension(xtr, conversionHelper);
                        continue;
                    }
                    if ("httpRequestHandler".equals(xtr.getLocalName())) {
                        this.readHttpRequestHandler(xtr, conversionHelper);
                        continue;
                    }
                    if ("httpResponseHandler".equals(xtr.getLocalName())) {
                        this.readHttpResponseHandler(xtr, conversionHelper);
                        continue;
                    }
                    if ("in".equals(xtr.getLocalName())) {
                        this.readIOParameter(xtr, true, conversionHelper);
                        continue;
                    }
                    if ("out".equals(xtr.getLocalName())) {
                        this.readIOParameter(xtr, false, conversionHelper);
                        continue;
                    }
                    if ("taskListener".equals(xtr.getLocalName())) {
                        this.readTaskListener(xtr, conversionHelper);
                        continue;
                    }
                    if ("planItemLifecycleListener".equals(xtr.getLocalName()) || "caseLifecycleListener".equals(xtr.getLocalName())) {
                        this.readLifecycleListener(xtr, conversionHelper);
                        continue;
                    }
                    if ("eventType".equals(xtr.getLocalName())) {
                        this.readEventType(xtr, conversionHelper);
                        continue;
                    }
                    ExtensionElement extensionElement = CmmnXmlUtil.parseExtensionElement(xtr);
                    conversionHelper.getCurrentCmmnElement().addExtensionElement(extensionElement);
                    continue;
                }
                if (!xtr.isEndElement()) continue;
                if ("taskListener".equalsIgnoreCase(xtr.getLocalName()) || "planItemLifecycleListener".equalsIgnoreCase(xtr.getLocalName()) || "caseLifecycleListener".equalsIgnoreCase(xtr.getLocalName())) {
                    conversionHelper.removeCurrentCmmnElement();
                    continue;
                }
                if (!"extensionElements".equalsIgnoreCase(xtr.getLocalName())) continue;
                readyWithChildElements = true;
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error processing CMMN document", (Throwable)ex);
            throw new XMLException("Error processing CMMN document", ex);
        }
        return null;
    }

    protected void readCompletionNeutralRule(XMLStreamReader xtr, ConversionHelper conversionHelper) {
        if (conversionHelper.getCurrentCmmnElement() instanceof PlanItemControl) {
            CompletionNeutralRule completionNeutralRule = new CompletionNeutralRule();
            completionNeutralRule.setName(xtr.getAttributeValue(null, "name"));
            PlanItemControl planItemControl = (PlanItemControl)conversionHelper.getCurrentCmmnElement();
            planItemControl.setCompletionNeutralRule(completionNeutralRule);
            this.readCommonXmlInfo((BaseElement)completionNeutralRule, xtr);
            boolean readyWithChildElements = false;
            try {
                while (!readyWithChildElements && xtr.hasNext()) {
                    xtr.next();
                    if (xtr.isStartElement()) {
                        if (!"condition".equals(xtr.getLocalName())) continue;
                        xtr.next();
                        if (xtr.isCharacters()) {
                            completionNeutralRule.setCondition(xtr.getText());
                        }
                        break;
                    }
                    if (!xtr.isEndElement() || !"completionNeutralRule".equalsIgnoreCase(xtr.getLocalName())) continue;
                    readyWithChildElements = true;
                }
            }
            catch (Exception ex) {
                LOGGER.error("Error processing CMMN document", (Throwable)ex);
                throw new XMLException("Error processing CMMN document", ex);
            }
        }
    }

    protected void readParentCompletionRule(XMLStreamReader xtr, ConversionHelper conversionHelper) {
        if (conversionHelper.getCurrentCmmnElement() instanceof PlanItemControl) {
            ParentCompletionRule parentCompletionRule = new ParentCompletionRule();
            parentCompletionRule.setName(xtr.getAttributeValue(null, "name"));
            parentCompletionRule.setType(xtr.getAttributeValue(null, "type"));
            PlanItemControl planItemControl = (PlanItemControl)conversionHelper.getCurrentCmmnElement();
            planItemControl.setParentCompletionRule(parentCompletionRule);
            this.readCommonXmlInfo((BaseElement)parentCompletionRule, xtr);
        }
    }

    protected void readFieldExtension(XMLStreamReader xtr, ConversionHelper conversionHelper) {
        CmmnElement cmmnElement = conversionHelper.getCurrentCmmnElement();
        FieldExtension extension = new FieldExtension();
        extension.setFieldName(xtr.getAttributeValue(null, "name"));
        String stringValueAttribute = xtr.getAttributeValue(null, "stringValue");
        String expressionAttribute = xtr.getAttributeValue(null, "expression");
        if (StringUtils.isNotEmpty((CharSequence)stringValueAttribute)) {
            extension.setStringValue(stringValueAttribute);
        } else if (StringUtils.isNotEmpty((CharSequence)expressionAttribute)) {
            extension.setExpression(expressionAttribute);
        } else {
            boolean readyWithFieldExtension = false;
            try {
                while (!readyWithFieldExtension && xtr.hasNext()) {
                    xtr.next();
                    if (xtr.isStartElement() && "string".equalsIgnoreCase(xtr.getLocalName())) {
                        extension.setStringValue(xtr.getElementText().trim());
                        continue;
                    }
                    if (xtr.isStartElement() && "expression".equalsIgnoreCase(xtr.getLocalName())) {
                        extension.setExpression(xtr.getElementText().trim());
                        continue;
                    }
                    if (!xtr.isEndElement() || !"field".equalsIgnoreCase(xtr.getLocalName())) continue;
                    readyWithFieldExtension = true;
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error parsing field extension child elements", (Throwable)e);
            }
        }
        CmmnElement currentCmmnElement = conversionHelper.getCurrentCmmnElement();
        if (currentCmmnElement instanceof ServiceTask) {
            ((ServiceTask)currentCmmnElement).getFieldExtensions().add(extension);
        } else if (currentCmmnElement instanceof DecisionTask) {
            ((DecisionTask)currentCmmnElement).getFieldExtensions().add(extension);
        } else if (currentCmmnElement instanceof FlowableListener) {
            ((FlowableListener)currentCmmnElement).getFieldExtensions().add(extension);
        } else {
            throw new FlowableException("Programmatic error: field added to unknown element '" + currentCmmnElement + "'");
        }
    }

    protected void readHttpRequestHandler(XMLStreamReader xtr, ConversionHelper conversionHelper) {
        CmmnElement cmmnElement = conversionHelper.getCurrentCmmnElement();
        if (!(cmmnElement instanceof HttpServiceTask)) {
            return;
        }
        FlowableHttpRequestHandler requestHandler = new FlowableHttpRequestHandler();
        this.setImplementation(xtr, (AbstractFlowableHttpHandler)requestHandler);
        ((HttpServiceTask)cmmnElement).setHttpRequestHandler(requestHandler);
    }

    protected void readHttpResponseHandler(XMLStreamReader xtr, ConversionHelper conversionHelper) {
        CmmnElement cmmnElement = conversionHelper.getCurrentCmmnElement();
        if (!(cmmnElement instanceof HttpServiceTask)) {
            return;
        }
        FlowableHttpResponseHandler responseHandler = new FlowableHttpResponseHandler();
        this.setImplementation(xtr, (AbstractFlowableHttpHandler)responseHandler);
        ((HttpServiceTask)cmmnElement).setHttpResponseHandler(responseHandler);
    }

    protected void readIOParameter(XMLStreamReader xtr, boolean isInParameter, ConversionHelper conversionHelper) {
        CmmnElement currentCmmnElement = conversionHelper.getCurrentCmmnElement();
        if (!(currentCmmnElement instanceof ChildTask)) {
            return;
        }
        ChildTask childTask = (ChildTask)currentCmmnElement;
        String source = xtr.getAttributeValue(null, "source");
        String sourceExpression = xtr.getAttributeValue(null, "sourceExpression");
        String target = xtr.getAttributeValue(null, "target");
        String targetExpression = xtr.getAttributeValue(null, "targetExpression");
        IOParameter parameter = new IOParameter();
        if (StringUtils.isNotEmpty((CharSequence)sourceExpression)) {
            parameter.setSourceExpression(sourceExpression);
        } else {
            parameter.setSource(source);
        }
        if (StringUtils.isNotEmpty((CharSequence)targetExpression)) {
            parameter.setTargetExpression(targetExpression);
        } else {
            parameter.setTarget(target);
        }
        if (isInParameter) {
            childTask.getInParameters().add(parameter);
        } else {
            childTask.getOutParameters().add(parameter);
        }
    }

    protected void readTaskListener(XMLStreamReader xtr, ConversionHelper conversionHelper) {
        CmmnElement currentCmmnElement = conversionHelper.getCurrentCmmnElement();
        FlowableListener flowableListener = ListenerXmlConverterUtil.convertToListener(xtr);
        if (flowableListener != null) {
            if (currentCmmnElement instanceof HumanTask) {
                HumanTask humanTask = (HumanTask)currentCmmnElement;
                humanTask.getTaskListeners().add(flowableListener);
            } else {
                throw new FlowableException("Programmatic error: task listener added to an element that is not a human task, but a " + currentCmmnElement.getClass());
            }
        }
        conversionHelper.setCurrentCmmnElement((CmmnElement)flowableListener);
    }

    protected void readLifecycleListener(XMLStreamReader xtr, ConversionHelper conversionHelper) {
        CmmnElement currentCmmnElement = conversionHelper.getCurrentCmmnElement();
        FlowableListener flowableListener = ListenerXmlConverterUtil.convertToListener(xtr);
        if (flowableListener != null) {
            if (currentCmmnElement instanceof HasLifecycleListeners) {
                HasLifecycleListeners lifecycleListenersElement = (HasLifecycleListeners)currentCmmnElement;
                lifecycleListenersElement.getLifecycleListeners().add(flowableListener);
            } else {
                throw new FlowableException("Programmatic error: lifecycle listener added to an element that is not a plan item definition, but a " + currentCmmnElement.getClass());
            }
        }
        conversionHelper.setCurrentCmmnElement((CmmnElement)flowableListener);
    }

    protected void setImplementation(XMLStreamReader xtr, AbstractFlowableHttpHandler handler) {
        if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "class"))) {
            handler.setImplementation(xtr.getAttributeValue(null, "class"));
            handler.setImplementationType("class");
        } else if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "delegateExpression"))) {
            handler.setImplementation(xtr.getAttributeValue(null, "delegateExpression"));
            handler.setImplementationType("delegateExpression");
        }
    }

    protected void readEventType(XMLStreamReader xtr, ConversionHelper conversionHelper) {
        CmmnElement currentCmmnElement = conversionHelper.getCurrentCmmnElement();
        String eventType = null;
        try {
            ExtensionElement extensionElement = CmmnXmlUtil.parseExtensionElement(xtr);
            eventType = extensionElement.getElementText();
        }
        catch (Exception e) {
            throw new FlowableException("Error while reading eventType element", (Throwable)e);
        }
        if (currentCmmnElement instanceof Case) {
            Case caze = (Case)currentCmmnElement;
            caze.setStartEventType(eventType);
        } else if (currentCmmnElement instanceof SendEventServiceTask) {
            SendEventServiceTask sendEventServiceTask = (SendEventServiceTask)currentCmmnElement;
            sendEventServiceTask.setEventType(eventType);
        } else if (currentCmmnElement instanceof GenericEventListener) {
            GenericEventListener genericEventListener = (GenericEventListener)currentCmmnElement;
            genericEventListener.setEventType(eventType);
        } else {
            LOGGER.warn("Unsupported eventType detected for element {}", (Object)currentCmmnElement);
        }
    }

    protected void readCommonXmlInfo(BaseElement baseElement, XMLStreamReader xtr) {
        baseElement.setId(xtr.getAttributeValue(null, "id"));
        Location location = xtr.getLocation();
        baseElement.setXmlRowNumber(location.getLineNumber());
        baseElement.setXmlRowNumber(location.getColumnNumber());
    }
}

