/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter;

import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.ConversionHelper;
import org.flowable.cmmn.converter.TaskXmlConverter;
import org.flowable.cmmn.model.CmmnElement;
import org.flowable.cmmn.model.HumanTask;
import org.flowable.cmmn.model.Task;

public class HumanTaskXmlConverter
extends TaskXmlConverter {
    @Override
    public String getXMLElementName() {
        return "humanTask";
    }

    @Override
    protected CmmnElement convert(XMLStreamReader xtr, ConversionHelper conversionHelper) {
        String candidateGroupsString;
        HumanTask task = new HumanTask();
        this.convertCommonTaskAttributes(xtr, (Task)task);
        task.setAssignee(xtr.getAttributeValue("http://flowable.org/cmmn", "assignee"));
        task.setOwner(xtr.getAttributeValue("http://flowable.org/cmmn", "owner"));
        task.setPriority(xtr.getAttributeValue("http://flowable.org/cmmn", "priority"));
        task.setFormKey(xtr.getAttributeValue("http://flowable.org/cmmn", "formKey"));
        String sameDeploymentAttribute = xtr.getAttributeValue("http://flowable.org/cmmn", "sameDeployment");
        if ("false".equalsIgnoreCase(sameDeploymentAttribute)) {
            task.setSameDeployment(false);
        }
        task.setValidateFormFields(xtr.getAttributeValue("http://flowable.org/cmmn", "formFieldValidation"));
        task.setDueDate(xtr.getAttributeValue("http://flowable.org/cmmn", "dueDate"));
        task.setCategory(xtr.getAttributeValue("http://flowable.org/cmmn", "category"));
        task.setTaskIdVariableName(xtr.getAttributeValue("http://flowable.org/cmmn", "taskIdVariableName"));
        String candidateUsersString = xtr.getAttributeValue("http://flowable.org/cmmn", "candidateUsers");
        if (StringUtils.isNotEmpty((CharSequence)candidateUsersString)) {
            String[] candidateUsers;
            for (String candidateUser : candidateUsers = candidateUsersString.split(",")) {
                task.getCandidateUsers().add(candidateUser);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(candidateGroupsString = xtr.getAttributeValue("http://flowable.org/cmmn", "candidateGroups")))) {
            String[] candidateGroups;
            for (String candidateGroup : candidateGroups = candidateGroupsString.split(",")) {
                task.getCandidateGroups().add(candidateGroup);
            }
        }
        return task;
    }
}

