/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.impl.agenda.operation.AbstractPlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.ManualActivationRule;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemControl;
import org.flowable.cmmn.model.Task;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivatePlanItemInstanceOperation
extends AbstractPlanItemInstanceOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivatePlanItemInstanceOperation.class);

    public ActivatePlanItemInstanceOperation(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        super(commandContext, planItemInstanceEntity);
    }

    @Override
    public void run() {
        if (this.isAsync() && !"async-active".equals(this.planItemInstanceEntity.getState())) {
            LOGGER.debug("Plan item {} is planned for asynchronous activatation", (Object)(this.planItemInstanceEntity.getPlanItem().getName() != null ? this.planItemInstanceEntity.getPlanItem().getName() : this.planItemInstanceEntity.getPlanItem().getId()));
            this.createAsyncJob((Task)this.planItemInstanceEntity.getPlanItem().getPlanItemDefinition());
            this.planItemInstanceEntity.setState("async-active");
            return;
        }
        this.deleteSentryPartInstances();
        boolean isManuallyActivated = this.evaluateManualActivationRule();
        if (isManuallyActivated) {
            CommandContextUtil.getAgenda(this.commandContext).planEnablePlanItemInstanceOperation(this.planItemInstanceEntity);
        } else {
            CommandContextUtil.getAgenda(this.commandContext).planStartPlanItemInstanceOperation(this.planItemInstanceEntity);
        }
    }

    protected boolean evaluateManualActivationRule() {
        PlanItemControl planItemControl = this.planItemInstanceEntity.getPlanItem().getItemControl();
        if (planItemControl != null && planItemControl.getManualActivationRule() != null) {
            ManualActivationRule manualActivationRule = planItemControl.getManualActivationRule();
            if (StringUtils.isNotEmpty((CharSequence)manualActivationRule.getCondition())) {
                return this.evaluateBooleanExpression(this.commandContext, this.planItemInstanceEntity, manualActivationRule.getCondition());
            }
            return true;
        }
        return false;
    }

    protected boolean isAsync() {
        Task task;
        return this.planItemInstanceEntity.getPlanItem().getPlanItemDefinition() instanceof Task && (task = (Task)this.planItemInstanceEntity.getPlanItem().getPlanItemDefinition()).isAsync();
    }

    protected void createAsyncJob(Task task) {
        JobService jobService = CommandContextUtil.getCmmnEngineConfiguration(this.commandContext).getJobServiceConfiguration().getJobService();
        JobEntity job = jobService.createJob();
        job.setScopeId(this.planItemInstanceEntity.getCaseInstanceId());
        job.setSubScopeId(this.planItemInstanceEntity.getId());
        job.setScopeDefinitionId(this.planItemInstanceEntity.getCaseDefinitionId());
        job.setScopeType("cmmn");
        job.setTenantId(this.planItemInstanceEntity.getTenantId());
        job.setJobHandlerType("cmmn-async-activate-plan-item-instance");
        jobService.createAsyncJob(job, task.isExclusive());
        jobService.scheduleAsyncJob(job);
    }

    public String toString() {
        PlanItem planItem = this.planItemInstanceEntity.getPlanItem();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[Activate PlanItem] ");
        if (planItem.getName() != null) {
            stringBuilder.append(planItem.getName());
            stringBuilder.append(" (");
            stringBuilder.append(planItem.getId());
            stringBuilder.append(")");
        } else {
            stringBuilder.append(planItem.getId());
        }
        return stringBuilder.toString();
    }
}

