/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cfg;

import java.util.Collections;
import java.util.List;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeAliasRegistry;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.flowable.engine.common.impl.AbstractEngineConfiguration;
import org.flowable.engine.common.impl.AbstractEngineConfigurator;
import org.flowable.engine.common.impl.EngineDeployer;
import org.flowable.engine.common.impl.db.MybatisTypeAliasConfigurator;
import org.flowable.engine.common.impl.db.MybatisTypeHandlerConfigurator;
import org.flowable.engine.common.impl.persistence.entity.Entity;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.engine.impl.cfg.StandaloneIdmEngineConfiguration;
import org.flowable.idm.engine.impl.db.EntityDependencyOrder;
import org.flowable.idm.engine.impl.persistence.ByteArrayRefTypeHandler;
import org.flowable.idm.engine.impl.persistence.entity.ByteArrayRef;

public class IdmEngineConfigurator
extends AbstractEngineConfigurator {
    protected IdmEngineConfiguration idmEngineConfiguration;

    public int getPriority() {
        return 100000;
    }

    protected List<EngineDeployer> getCustomDeployers() {
        return null;
    }

    protected String getMybatisCfgPath() {
        return "org/flowable/idm/db/mapping/mappings.xml";
    }

    protected List<MybatisTypeAliasConfigurator> getMybatisTypeAliases() {
        return Collections.singletonList(new MybatisTypeAliasConfigurator(){

            public void configure(TypeAliasRegistry typeAliasRegistry) {
                typeAliasRegistry.registerAlias("IdmByteArrayRefTypeHandler", ByteArrayRefTypeHandler.class);
            }
        });
    }

    protected List<MybatisTypeHandlerConfigurator> getMybatisTypeHandlers() {
        return Collections.singletonList(new MybatisTypeHandlerConfigurator(){

            public void configure(TypeHandlerRegistry typeHandlerRegistry) {
                typeHandlerRegistry.register(ByteArrayRef.class, JdbcType.VARCHAR, ByteArrayRefTypeHandler.class);
            }
        });
    }

    public void configure(AbstractEngineConfiguration engineConfiguration) {
        if (this.idmEngineConfiguration == null) {
            this.idmEngineConfiguration = new StandaloneIdmEngineConfiguration();
        }
        this.initialiseCommonProperties(engineConfiguration, (AbstractEngineConfiguration)this.idmEngineConfiguration);
        this.idmEngineConfiguration.buildIdmEngine();
        this.initServiceConfigurations(engineConfiguration, (AbstractEngineConfiguration)this.idmEngineConfiguration);
    }

    protected List<Class<? extends Entity>> getEntityInsertionOrder() {
        return EntityDependencyOrder.INSERT_ORDER;
    }

    protected List<Class<? extends Entity>> getEntityDeletionOrder() {
        return EntityDependencyOrder.DELETE_ORDER;
    }

    public IdmEngineConfiguration getIdmEngineConfiguration() {
        return this.idmEngineConfiguration;
    }

    public IdmEngineConfigurator setIdmEngineConfiguration(IdmEngineConfiguration idmEngineConfiguration) {
        this.idmEngineConfiguration = idmEngineConfiguration;
        return this;
    }
}

