/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.flowable.cmmn.converter.CmmnXMLException;
import org.flowable.cmmn.converter.CmmnXmlConverter;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.parser.CmmnActivityBehaviorFactory;
import org.flowable.cmmn.engine.impl.parser.CmmnParseResult;
import org.flowable.cmmn.engine.impl.parser.CmmnParser;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CaseTask;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.DecisionTask;
import org.flowable.cmmn.model.HumanTask;
import org.flowable.cmmn.model.ImplementationType;
import org.flowable.cmmn.model.Milestone;
import org.flowable.cmmn.model.PlanFragment;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.ProcessTask;
import org.flowable.cmmn.model.ScriptServiceTask;
import org.flowable.cmmn.model.ServiceTask;
import org.flowable.cmmn.model.Stage;
import org.flowable.cmmn.model.Task;
import org.flowable.cmmn.model.TimerEventListener;
import org.flowable.cmmn.model.UserEventListener;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.io.InputStreamProvider;
import org.flowable.engine.common.api.repository.EngineResource;
import org.flowable.engine.common.impl.el.ExpressionManager;
import org.flowable.engine.common.impl.util.io.InputStreamSource;
import org.flowable.engine.common.impl.util.io.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmmnParserImpl
implements CmmnParser {
    private final Logger logger = LoggerFactory.getLogger(CmmnParserImpl.class);
    protected CmmnActivityBehaviorFactory activityBehaviorFactory;
    protected ExpressionManager expressionManager;

    @Override
    public CmmnParseResult parse(EngineResource resourceEntity) {
        CmmnParseResult parseResult = new CmmnParseResult();
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(resourceEntity.getBytes());){
            Pair<CmmnModel, List<CaseDefinitionEntity>> pair = this.parse(resourceEntity, parseResult, (StreamSource)new InputStreamSource((InputStream)inputStream));
            for (CaseDefinitionEntity caseDefinitionEntity : (List)pair.getRight()) {
                parseResult.addCaseDefinition(caseDefinitionEntity, resourceEntity, (CmmnModel)pair.getLeft());
            }
            this.processDI((CmmnModel)pair.getLeft(), (List)pair.getRight());
        }
        catch (IOException e) {
            this.logger.error("Could not read bytes from CMMN resource", (Throwable)e);
        }
        return parseResult;
    }

    public Pair<CmmnModel, List<CaseDefinitionEntity>> parse(EngineResource resourceEntity, CmmnParseResult parseResult, StreamSource cmmnSource) {
        try {
            boolean enableSafeBpmnXml = false;
            String encoding = null;
            CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration();
            if (cmmnEngineConfiguration != null) {
                enableSafeBpmnXml = cmmnEngineConfiguration.isEnableSafeCmmnXml();
                encoding = cmmnEngineConfiguration.getXmlEncoding();
            }
            CmmnModel cmmnModel = new CmmnXmlConverter().convertToCmmnModel((InputStreamProvider)cmmnSource, true, enableSafeBpmnXml, encoding);
            List<CaseDefinitionEntity> caseDefinitionEntities = this.processCmmnElements(resourceEntity, cmmnModel);
            return Pair.of((Object)cmmnModel, caseDefinitionEntities);
        }
        catch (Exception e) {
            if (e instanceof FlowableException) {
                throw (FlowableException)e;
            }
            if (e instanceof CmmnXMLException) {
                throw (CmmnXMLException)e;
            }
            throw new FlowableException("Error parsing XML", (Throwable)e);
        }
    }

    protected List<CaseDefinitionEntity> processCmmnElements(EngineResource resourceEntity, CmmnModel cmmnModel) {
        ArrayList<CaseDefinitionEntity> caseDefinitionEntities = new ArrayList<CaseDefinitionEntity>();
        for (Case caze : cmmnModel.getCases()) {
            CaseDefinitionEntity caseDefinitionEntity = (CaseDefinitionEntity)CommandContextUtil.getCaseDefinitionEntityManager().create();
            caseDefinitionEntity.setKey(caze.getId());
            caseDefinitionEntity.setName(caze.getName());
            caseDefinitionEntity.setCategory(cmmnModel.getTargetNamespace());
            caseDefinitionEntity.setDeploymentId(resourceEntity.getDeploymentId());
            caseDefinitionEntities.add(caseDefinitionEntity);
            this.processPlanFragment((PlanFragment)caze.getPlanModel());
        }
        return caseDefinitionEntities;
    }

    protected void processPlanFragment(PlanFragment planFragment) {
        for (PlanItem planItem : planFragment.getPlanItems()) {
            PlanItemDefinition planItemDefinition;
            block13: {
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    block17: {
                                        block16: {
                                            block15: {
                                                block14: {
                                                    block12: {
                                                        planItemDefinition = planItem.getPlanItemDefinition();
                                                        if (!(planItemDefinition instanceof Stage)) break block12;
                                                        Stage stage = (Stage)planItemDefinition;
                                                        planItem.setBehavior((Object)this.activityBehaviorFactory.createStageActivityBehavoir(planItem, stage));
                                                        break block13;
                                                    }
                                                    if (!(planItemDefinition instanceof HumanTask)) break block14;
                                                    HumanTask humanTask = (HumanTask)planItemDefinition;
                                                    planItem.setBehavior((Object)this.activityBehaviorFactory.createHumanTaskActivityBehavior(planItem, humanTask));
                                                    break block13;
                                                }
                                                if (!(planItemDefinition instanceof CaseTask)) break block15;
                                                CaseTask caseTask = (CaseTask)planItemDefinition;
                                                planItem.setBehavior((Object)this.activityBehaviorFactory.createCaseTaskActivityBehavior(planItem, caseTask));
                                                break block13;
                                            }
                                            if (!(planItemDefinition instanceof ProcessTask)) break block16;
                                            ProcessTask processTask = (ProcessTask)planItemDefinition;
                                            planItem.setBehavior((Object)this.activityBehaviorFactory.createProcessTaskActivityBehavior(planItem, processTask));
                                            break block13;
                                        }
                                        if (!(planItemDefinition instanceof DecisionTask)) break block17;
                                        DecisionTask decisionTask = (DecisionTask)planItemDefinition;
                                        planItem.setBehavior((Object)this.activityBehaviorFactory.createDecisionTaskActivityBehavior(planItem, decisionTask));
                                        break block13;
                                    }
                                    if (!(planItemDefinition instanceof Milestone)) break block18;
                                    Milestone milestone = (Milestone)planItemDefinition;
                                    planItem.setBehavior((Object)this.activityBehaviorFactory.createMilestoneActivityBehavior(planItem, milestone));
                                    break block13;
                                }
                                if (!(planItemDefinition instanceof TimerEventListener)) break block19;
                                TimerEventListener timerEventListener = (TimerEventListener)planItemDefinition;
                                planItem.setBehavior((Object)this.activityBehaviorFactory.createTimerEventListenerActivityBehavior(planItem, timerEventListener));
                                break block13;
                            }
                            if (!(planItemDefinition instanceof UserEventListener)) break block20;
                            UserEventListener userEventListener = (UserEventListener)planItemDefinition;
                            planItem.setBehavior((Object)this.activityBehaviorFactory.createUserEventListenerActivityBehavior(planItem, userEventListener));
                            break block13;
                        }
                        if (!(planItemDefinition instanceof ScriptServiceTask)) break block21;
                        planItem.setBehavior((Object)this.activityBehaviorFactory.createScriptTaskActivityBehavior(planItem, (ScriptServiceTask)planItemDefinition));
                        break block13;
                    }
                    if (!(planItemDefinition instanceof ServiceTask)) break block22;
                    ServiceTask serviceTask = (ServiceTask)planItemDefinition;
                    switch (serviceTask.getType()) {
                        case "http": {
                            planItem.setBehavior((Object)this.activityBehaviorFactory.createHttpActivityBehavior(planItem, serviceTask));
                            break;
                        }
                        default: {
                            if (StringUtils.isNotEmpty((CharSequence)serviceTask.getImplementation())) {
                                if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equals(serviceTask.getImplementationType())) {
                                    planItem.setBehavior((Object)this.activityBehaviorFactory.createCmmnClassDelegate(planItem, serviceTask));
                                    break;
                                }
                                if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equals(serviceTask.getImplementationType())) {
                                    planItem.setBehavior((Object)this.activityBehaviorFactory.createPlanItemExpressionActivityBehavior(planItem, serviceTask));
                                    break;
                                }
                                if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equals(serviceTask.getImplementationType())) {
                                    planItem.setBehavior((Object)this.activityBehaviorFactory.createPlanItemDelegateExpressionActivityBehavior(planItem, serviceTask));
                                    break;
                                } else {
                                    break;
                                }
                            } else {
                                break;
                            }
                        }
                    }
                    break block13;
                }
                if (planItemDefinition instanceof Task) {
                    planItem.setBehavior((Object)this.activityBehaviorFactory.createTaskActivityBehavior(planItem, (Task)planItemDefinition));
                }
            }
            if (!(planItemDefinition instanceof PlanFragment)) continue;
            this.processPlanFragment((PlanFragment)planItemDefinition);
        }
    }

    public void processDI(CmmnModel cmmnModel, List<CaseDefinitionEntity> caseDefinitions) {
        if (caseDefinitions.isEmpty()) {
            return;
        }
        if (!cmmnModel.getLocationMap().isEmpty()) {
            ArrayList<String> planModelIds = new ArrayList<String>();
            for (Case caseObject : cmmnModel.getCases()) {
                planModelIds.add(caseObject.getPlanModel().getId());
            }
            for (String cmmnReference : cmmnModel.getLocationMap().keySet()) {
                if (planModelIds.contains(cmmnReference) || cmmnModel.findPlanItem(cmmnReference) != null || cmmnModel.getCriterion(cmmnReference) != null) continue;
                this.logger.warn("Invalid reference in diagram interchange definition: could not find {}", (Object)cmmnReference);
            }
            for (Case caseObject : cmmnModel.getCases()) {
                CaseDefinitionEntity caseDefinition = this.getCaseDefinition(caseObject.getId(), caseDefinitions);
                if (caseDefinition == null) continue;
                caseDefinition.setHasGraphicalNotation(true);
            }
        }
    }

    public CaseDefinitionEntity getCaseDefinition(String caseDefinitionKey, List<CaseDefinitionEntity> caseDefinitions) {
        for (CaseDefinitionEntity caseDefinition : caseDefinitions) {
            if (!caseDefinition.getKey().equals(caseDefinitionKey)) continue;
            return caseDefinition;
        }
        return null;
    }

    public CmmnActivityBehaviorFactory getActivityBehaviorFactory() {
        return this.activityBehaviorFactory;
    }

    public void setActivityBehaviorFactory(CmmnActivityBehaviorFactory activityBehaviorFactory) {
        this.activityBehaviorFactory = activityBehaviorFactory;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public void setExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }
}

