/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.test.impl;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.flowable.cmmn.api.repository.CmmnDeploymentBuilder;
import org.flowable.cmmn.engine.CmmnEngine;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.test.CmmnDeployment;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.impl.util.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CmmnTestHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmmnTestHelper.class);
    public static final String[] CMMN_RESOURCE_SUFFIXES = new String[]{"cmmn11.xml", "cmmn"};
    static Map<String, CmmnEngine> cmmnEngines = new HashMap<String, CmmnEngine>();

    public static String annotationDeploymentSetUp(CmmnEngine cmmnEngine, Class<?> testClass, String methodName) {
        String deploymentId = null;
        Method method = null;
        try {
            method = testClass.getMethod(methodName, null);
        }
        catch (Exception e) {
            LOGGER.warn("Could not get method by reflection. This could happen if you are using @Parameters in combination with annotations.", (Throwable)e);
            return null;
        }
        CmmnDeployment deploymentAnnotation = method.getAnnotation(CmmnDeployment.class);
        if (deploymentAnnotation != null) {
            LOGGER.debug("annotation @CmmnDeployment creates deployment for {}.{}", (Object)testClass.getSimpleName(), (Object)methodName);
            String[] resources = deploymentAnnotation.resources();
            if (resources.length == 0) {
                String name = method.getName();
                String resource = CmmnTestHelper.getCmmnCaseDefinitionResource(testClass, name);
                resources = new String[]{resource};
            }
            CmmnDeploymentBuilder deploymentBuilder = cmmnEngine.getCmmnRepositoryService().createDeployment().name(testClass.getSimpleName() + "." + methodName);
            for (String resource : resources) {
                deploymentBuilder.addClasspathResource(resource);
            }
            if (deploymentAnnotation.tenantId() != null && deploymentAnnotation.tenantId().length() > 0) {
                deploymentBuilder.tenantId(deploymentAnnotation.tenantId());
            }
            deploymentId = deploymentBuilder.deploy().getId();
        }
        return deploymentId;
    }

    public static void annotationDeploymentTearDown(CmmnEngine cmmnEngine, String deploymentId, Class<?> testClass, String methodName) {
        LOGGER.debug("annotation @CmmnDeployment deletes deployment for {}.{}", (Object)testClass.getSimpleName(), (Object)methodName);
        if (deploymentId != null) {
            try {
                cmmnEngine.getCmmnRepositoryService().deleteDeployment(deploymentId, true);
            }
            catch (FlowableObjectNotFoundException flowableObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    public static CmmnEngine getCmmnEngine(String configurationResource) {
        CmmnEngine cmmnEngine = cmmnEngines.get(configurationResource);
        if (cmmnEngine == null) {
            LOGGER.debug("==== BUILDING PROCESS ENGINE ========================================================================");
            cmmnEngine = CmmnEngineConfiguration.createCmmnEngineConfigurationFromResource(configurationResource).buildCmmnEngine();
            LOGGER.debug("==== PROCESS ENGINE CREATED =========================================================================");
            cmmnEngines.put(configurationResource, cmmnEngine);
        }
        return cmmnEngine;
    }

    public static String getCmmnCaseDefinitionResource(Class<?> type, String name) {
        for (String suffix : CMMN_RESOURCE_SUFFIXES) {
            String resource = type.getName().replace('.', '/') + "." + name + "." + suffix;
            InputStream inputStream = ReflectUtil.getResourceAsStream((String)resource);
            if (inputStream == null) continue;
            return resource;
        }
        return type.getName().replace('.', '/') + "." + name + "." + CMMN_RESOURCE_SUFFIXES[1];
    }
}

