/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.flowable.cmmn.engine.impl.behavior.impl.TaskActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.ScriptServiceTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.scripting.ScriptingEngines;
import org.flowable.variable.api.delegate.VariableScope;

public class ScriptTaskActivityBehavior
extends TaskActivityBehavior {
    protected ScriptServiceTask scriptTask;

    public ScriptTaskActivityBehavior(ScriptServiceTask scriptTask) {
        super(scriptTask.isBlocking(), scriptTask.getBlockingExpression());
        this.scriptTask = scriptTask;
    }

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        ScriptingEngines scriptingEngines = CommandContextUtil.getCmmnEngineConfiguration().getScriptingEngines();
        if (scriptingEngines == null) {
            throw new FlowableException("Could not execute script task instance: no scripting engines found.");
        }
        String scriptFormat = this.scriptTask.getScriptFormat() != null ? this.scriptTask.getScriptFormat() : "juel";
        try {
            Object result = scriptingEngines.evaluate(this.scriptTask.getScript(), scriptFormat, (VariableScope)planItemInstanceEntity, this.scriptTask.isAutoStoreVariables());
            String resultVariableName = this.scriptTask.getResultVariableName();
            if (StringUtils.isNotBlank((CharSequence)this.scriptTask.getResultVariableName())) {
                planItemInstanceEntity.setVariable(resultVariableName.trim(), result);
            }
            CommandContextUtil.getAgenda(commandContext).planCompletePlanItemInstanceOperation(planItemInstanceEntity);
        }
        catch (FlowableException e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof FlowableException) {
                throw (FlowableException)rootCause;
            }
            throw e;
        }
    }
}

