/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class DeleteIdentityLinkForCaseDefinitionCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String caseDefinitionId;
    protected String userId;
    protected String groupId;

    public DeleteIdentityLinkForCaseDefinitionCmd(String caseDefinitionId, String userId, String groupId) {
        this.validateParams(userId, groupId, caseDefinitionId);
        this.caseDefinitionId = caseDefinitionId;
        this.userId = userId;
        this.groupId = groupId;
    }

    protected void validateParams(String userId, String groupId, String caseDefinitionId) {
        if (caseDefinitionId == null) {
            throw new FlowableIllegalArgumentException("caseDefinitionId is null");
        }
        if (userId == null && groupId == null) {
            throw new FlowableIllegalArgumentException("userId and groupId cannot both be null");
        }
    }

    public Void execute(CommandContext commandContext) {
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        CaseDefinitionEntity caseDefinition = (CaseDefinitionEntity)cmmnEngineConfiguration.getCaseDefinitionEntityManager().findById(this.caseDefinitionId);
        if (caseDefinition == null) {
            throw new FlowableObjectNotFoundException("Cannot find case definition with id " + this.caseDefinitionId, CaseDefinition.class);
        }
        cmmnEngineConfiguration.getIdentityLinkServiceConfiguration().getIdentityLinkService().deleteScopeDefinitionIdentityLink(caseDefinition.getId(), "cmmn", this.userId, this.groupId);
        return null;
    }
}

