/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.engine.impl.behavior.PlanItemActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.EntityWithSentryPartInstances;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.SentryIfPart;
import org.flowable.cmmn.model.SentryOnPart;
import org.flowable.cmmn.model.ServiceTask;
import org.flowable.common.engine.impl.logging.LoggingSessionUtil;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class CmmnLoggingSessionUtil {
    public static void addLoggingData(String type, String message, CaseInstanceEntity caseInstanceEntity, ObjectMapper objectMapper) {
        ObjectNode loggingNode = LoggingSessionUtil.fillLoggingData((String)message, (String)caseInstanceEntity.getId(), null, (String)"cmmn", (ObjectMapper)objectMapper);
        loggingNode.put("scopeDefinitionId", caseInstanceEntity.getCaseDefinitionId());
        CmmnLoggingSessionUtil.fillScopeDefinitionInfo(caseInstanceEntity.getCaseDefinitionId(), loggingNode);
        LoggingSessionUtil.addLoggingData((String)type, (ObjectNode)loggingNode, (String)"cmmn");
    }

    public static void addLoggingData(String type, String message, PlanItemInstanceEntity planItemInstanceEntity, ObjectMapper objectMapper) {
        CmmnLoggingSessionUtil.addLoggingData(type, message, null, null, planItemInstanceEntity, objectMapper);
    }

    public static void addLoggingData(String type, String message, String oldState, String newState, PlanItemInstanceEntity planItemInstanceEntity, ObjectMapper objectMapper) {
        ObjectNode loggingNode = CmmnLoggingSessionUtil.fillPlanItemInstanceInfo(message, planItemInstanceEntity, objectMapper);
        loggingNode.put("state", planItemInstanceEntity.getState());
        if (oldState != null) {
            loggingNode.put("oldState", oldState);
        }
        if (newState != null) {
            loggingNode.put("newState", newState);
        }
        CmmnLoggingSessionUtil.fillScopeDefinitionInfo(planItemInstanceEntity.getCaseDefinitionId(), loggingNode);
        LoggingSessionUtil.addLoggingData((String)type, (ObjectNode)loggingNode, (String)"cmmn");
    }

    public static void addLoggingData(String type, String message, TaskEntity task, PlanItemInstanceEntity planItemInstanceEntity, ObjectMapper objectMapper) {
        ObjectNode loggingNode = LoggingSessionUtil.fillLoggingData((String)message, (String)task.getScopeId(), (String)task.getSubScopeId(), (String)"cmmn", (ObjectMapper)objectMapper);
        loggingNode.put("scopeDefinitionId", planItemInstanceEntity.getCaseDefinitionId());
        loggingNode.put("taskId", task.getId());
        CmmnLoggingSessionUtil.putIfNotNull("taskName", task.getName(), loggingNode);
        CmmnLoggingSessionUtil.putIfNotNull("taskCategory", task.getCategory(), loggingNode);
        CmmnLoggingSessionUtil.putIfNotNull("taskFormKey", task.getFormKey(), loggingNode);
        CmmnLoggingSessionUtil.putIfNotNull("taskDescription", task.getDescription(), loggingNode);
        CmmnLoggingSessionUtil.putIfNotNull("taskDueDate", task.getDueDate(), loggingNode);
        CmmnLoggingSessionUtil.putIfNotNull("taskPriority", task.getPriority(), loggingNode);
        CmmnLoggingSessionUtil.fillScopeDefinitionInfo(planItemInstanceEntity.getCaseDefinitionId(), loggingNode);
        CmmnLoggingSessionUtil.fillPlanItemDefinitionInfo(loggingNode, planItemInstanceEntity);
        LoggingSessionUtil.addLoggingData((String)type, (ObjectNode)loggingNode, (String)"cmmn");
    }

    public static void addExecuteActivityBehaviorLoggingData(String type, PlanItemActivityBehavior activityBehavior, PlanItemDefinition planItemDefinition, PlanItemInstanceEntity planItemInstanceEntity, ObjectMapper objectMapper) {
        String message = "In " + planItemDefinition.getClass().getSimpleName() + ", executing " + activityBehavior.getClass().getSimpleName();
        ObjectNode loggingNode = LoggingSessionUtil.fillLoggingData((String)message, (String)planItemInstanceEntity.getCaseInstanceId(), (String)planItemInstanceEntity.getId(), (String)"cmmn", (ObjectMapper)objectMapper);
        loggingNode.put("scopeDefinitionId", planItemInstanceEntity.getCaseDefinitionId());
        loggingNode.put("elementId", planItemDefinition.getId());
        CmmnLoggingSessionUtil.putIfNotNull("elementName", planItemDefinition.getName(), loggingNode);
        loggingNode.put("elementType", planItemDefinition.getClass().getSimpleName());
        CmmnLoggingSessionUtil.putIfNotNull("elementSubType", CmmnLoggingSessionUtil.getActivitySubType(planItemDefinition), loggingNode);
        loggingNode.put("activityBehavior", activityBehavior.getClass().getSimpleName());
        CmmnLoggingSessionUtil.fillScopeDefinitionInfo(planItemInstanceEntity.getCaseDefinitionId(), loggingNode);
        LoggingSessionUtil.addLoggingData((String)type, (ObjectNode)loggingNode, (String)"cmmn");
    }

    public static void addAsyncActivityLoggingData(String message, String type, JobEntity jobEntity, PlanItemDefinition planItemDefinition, PlanItemInstanceEntity planItemInstanceEntity, ObjectMapper objectMapper) {
        ObjectNode loggingNode = LoggingSessionUtil.fillLoggingData((String)message, (String)planItemInstanceEntity.getCaseInstanceId(), (String)planItemInstanceEntity.getId(), (String)"cmmn", (ObjectMapper)objectMapper);
        loggingNode.put("scopeDefinitionId", planItemInstanceEntity.getCaseDefinitionId());
        loggingNode.put("elementId", planItemDefinition.getId());
        CmmnLoggingSessionUtil.putIfNotNull("elementName", planItemDefinition.getName(), loggingNode);
        loggingNode.put("elementType", planItemDefinition.getClass().getSimpleName());
        CmmnLoggingSessionUtil.putIfNotNull("elementSubType", CmmnLoggingSessionUtil.getActivitySubType(planItemDefinition), loggingNode);
        loggingNode.put("jobId", jobEntity.getId());
        CmmnLoggingSessionUtil.fillScopeDefinitionInfo(planItemInstanceEntity.getCaseDefinitionId(), loggingNode);
        LoggingSessionUtil.addLoggingData((String)type, (ObjectNode)loggingNode, (String)"cmmn");
    }

    public static ObjectNode fillBasicTaskLoggingData(String message, TaskEntity task, PlanItemInstanceEntity planItemInstanceEntity, ObjectMapper objectMapper) {
        ObjectNode loggingNode = LoggingSessionUtil.fillLoggingData((String)message, (String)task.getScopeId(), (String)task.getSubScopeId(), (String)"cmmn", (ObjectMapper)objectMapper);
        loggingNode.put("scopeDefinitionId", planItemInstanceEntity.getCaseDefinitionId());
        loggingNode.put("taskId", task.getId());
        CmmnLoggingSessionUtil.putIfNotNull("taskName", task.getName(), loggingNode);
        CmmnLoggingSessionUtil.fillScopeDefinitionInfo(planItemInstanceEntity.getCaseDefinitionId(), loggingNode);
        CmmnLoggingSessionUtil.fillPlanItemDefinitionInfo(loggingNode, planItemInstanceEntity);
        return loggingNode;
    }

    public static void addEvaluateSentryLoggingData(List<SentryOnPart> sentryOnParts, SentryIfPart sentryIfPart, EntityWithSentryPartInstances instance, ObjectMapper objectMapper) {
        ObjectNode loggingNode = CmmnLoggingSessionUtil.fillEvaluateSentryInstanceEntity(instance, objectMapper);
        ArrayNode onPartArrayNode = loggingNode.putArray("onParts");
        for (SentryOnPart onPart : sentryOnParts) {
            ObjectNode onPartNode = onPartArrayNode.addObject();
            onPartNode.put("id", onPart.getId());
            onPartNode.put("source", onPart.getSourceRef());
            onPartNode.put("elementId", onPart.getSource().getPlanItemDefinition().getId());
            onPartNode.put("standardEvent", onPart.getStandardEvent());
        }
        ObjectNode ifPartNode = loggingNode.putObject("ifPart");
        ifPartNode.put("condition", sentryIfPart.getCondition());
        LoggingSessionUtil.addLoggingData((String)"evaluateSentry", (ObjectNode)loggingNode, (String)"cmmn");
    }

    public static void addEvaluateSentryLoggingData(List<SentryOnPart> sentryOnParts, EntityWithSentryPartInstances instance, ObjectMapper objectMapper) {
        ObjectNode loggingNode = CmmnLoggingSessionUtil.fillEvaluateSentryInstanceEntity(instance, objectMapper);
        ArrayNode onPartArrayNode = loggingNode.putArray("onParts");
        for (SentryOnPart onPart : sentryOnParts) {
            ObjectNode onPartNode = onPartArrayNode.addObject();
            onPartNode.put("id", onPart.getId());
            onPartNode.put("source", onPart.getSourceRef());
            onPartNode.put("elementId", onPart.getSource().getPlanItemDefinition().getId());
            onPartNode.put("standardEvent", onPart.getStandardEvent());
        }
        LoggingSessionUtil.addLoggingData((String)"evaluateSentry", (ObjectNode)loggingNode, (String)"cmmn");
    }

    public static void addEvaluateSentryLoggingData(SentryIfPart sentryIfPart, EntityWithSentryPartInstances instance, ObjectMapper objectMapper) {
        ObjectNode loggingNode = CmmnLoggingSessionUtil.fillEvaluateSentryInstanceEntity(instance, objectMapper);
        ObjectNode ifPartNode = loggingNode.putObject("ifPart");
        ifPartNode.put("condition", sentryIfPart.getCondition());
        LoggingSessionUtil.addLoggingData((String)"evaluateSentry", (ObjectNode)loggingNode, (String)"cmmn");
    }

    public static void addEvaluateSentryFailedLoggingData(SentryIfPart sentryIfPart, RuntimeException e, EntityWithSentryPartInstances instance, ObjectMapper objectMapper) {
        ObjectNode loggingNode = CmmnLoggingSessionUtil.fillEvaluateSentryInstanceEntity(instance, objectMapper);
        String label = null;
        if (instance instanceof PlanItemInstanceEntity) {
            PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)instance;
            label = planItemInstanceEntity.getPlanItemDefinitionId();
            if (StringUtils.isNotEmpty((CharSequence)planItemInstanceEntity.getPlanItemDefinition().getName())) {
                label = planItemInstanceEntity.getPlanItemDefinition().getName();
            }
        } else {
            label = instance.getId();
        }
        loggingNode.put("message", "IfPart evaluation failed for " + label);
        ObjectNode ifPartNode = loggingNode.putObject("ifPart");
        ifPartNode.put("condition", sentryIfPart.getCondition());
        LoggingSessionUtil.addErrorLoggingData((String)"evaluateSentryFailed", (ObjectNode)loggingNode, (Throwable)e, (String)"cmmn");
    }

    public static void addErrorLoggingData(String type, String message, Throwable t, PlanItemInstanceEntity planItemInstanceEntity, ObjectMapper objectMapper) {
        ObjectNode loggingNode = CmmnLoggingSessionUtil.fillPlanItemInstanceInfo(message, planItemInstanceEntity, objectMapper);
        CmmnLoggingSessionUtil.fillScopeDefinitionInfo(planItemInstanceEntity.getCaseDefinitionId(), loggingNode);
        LoggingSessionUtil.addErrorLoggingData((String)type, (ObjectNode)loggingNode, (Throwable)t, (String)"cmmn");
    }

    public static void fillLoggingData(ObjectNode loggingNode, PlanItemInstanceEntity planItemInstanceEntity) {
        loggingNode.put("scopeDefinitionId", planItemInstanceEntity.getCaseDefinitionId());
        CmmnLoggingSessionUtil.fillScopeDefinitionInfo(planItemInstanceEntity.getCaseDefinitionId(), loggingNode);
        PlanItemDefinition planItemDefinition = planItemInstanceEntity.getPlanItemDefinition();
        if (planItemDefinition != null) {
            loggingNode.put("elementId", planItemDefinition.getId());
            CmmnLoggingSessionUtil.putIfNotNull("elementName", planItemDefinition.getName(), loggingNode);
            loggingNode.put("elementType", planItemDefinition.getClass().getSimpleName());
        }
    }

    public static void fillLoggingData(ObjectNode loggingNode, CaseInstanceEntity caseInstanceEntity) {
        loggingNode.put("scopeDefinitionId", caseInstanceEntity.getCaseDefinitionId());
        CmmnLoggingSessionUtil.fillScopeDefinitionInfo(caseInstanceEntity.getCaseDefinitionId(), loggingNode);
    }

    public static void addTaskIdentityLinkData(String type, String message, boolean isUser, List<IdentityLinkEntity> identityLinkEntities, TaskEntity task, PlanItemInstanceEntity planItemInstanceEntity, ObjectMapper objectMapper) {
        ObjectNode loggingNode = CmmnLoggingSessionUtil.fillBasicTaskLoggingData(message, task, planItemInstanceEntity, objectMapper);
        ArrayNode identityLinkArray = null;
        identityLinkArray = isUser ? loggingNode.putArray("taskUserIdentityLinks") : loggingNode.putArray("taskGroupIdentityLinks");
        for (IdentityLinkEntity identityLink : identityLinkEntities) {
            ObjectNode identityLinkNode = identityLinkArray.addObject();
            identityLinkNode.put("id", identityLink.getId());
            identityLinkNode.put("type", identityLink.getType());
            if (isUser) {
                identityLinkNode.put("userId", identityLink.getUserId());
                continue;
            }
            identityLinkNode.put("groupId", identityLink.getGroupId());
        }
        LoggingSessionUtil.addLoggingData((String)type, (ObjectNode)loggingNode, (String)"cmmn");
    }

    protected static String getActivitySubType(PlanItemDefinition planItemDefinition) {
        String activitySubType = null;
        if (planItemDefinition instanceof ServiceTask) {
            ServiceTask serviceTask = (ServiceTask)planItemDefinition;
            activitySubType = serviceTask.getImplementation();
        }
        return activitySubType;
    }

    protected static void fillScopeDefinitionInfo(String caseDefinitionId, ObjectNode loggingNode) {
        if (!loggingNode.has("scopeDefinitionId")) {
            loggingNode.put("scopeDefinitionId", caseDefinitionId);
        }
        CaseDefinition caseDefinition = CaseDefinitionUtil.getCaseDefinition(caseDefinitionId);
        loggingNode.put("scopeDefinitionKey", caseDefinition.getKey());
        loggingNode.put("scopeDefinitionName", caseDefinition.getName());
    }

    protected static ObjectNode fillPlanItemInstanceInfo(String message, PlanItemInstanceEntity planItemInstanceEntity, ObjectMapper objectMapper) {
        PlanItemDefinition planItemDefinition = planItemInstanceEntity.getPlanItemDefinition();
        String activityId = null;
        String activityName = null;
        String activityType = null;
        String activitySubType = null;
        if (planItemDefinition != null) {
            activityId = planItemDefinition.getId();
            activityName = planItemDefinition.getName();
            activityType = planItemDefinition.getClass().getSimpleName();
            activitySubType = CmmnLoggingSessionUtil.getActivitySubType(planItemDefinition);
        }
        return LoggingSessionUtil.fillLoggingData((String)message, (String)planItemInstanceEntity.getCaseInstanceId(), (String)planItemInstanceEntity.getId(), (String)"cmmn", (String)planItemInstanceEntity.getCaseDefinitionId(), (String)activityId, (String)activityName, (String)activityType, (String)activitySubType, (ObjectMapper)objectMapper);
    }

    protected static ObjectNode fillEvaluateSentryInstanceEntity(EntityWithSentryPartInstances instance, ObjectMapper objectMapper) {
        ObjectNode loggingNode = null;
        String caseDefinitionId = null;
        if (instance instanceof PlanItemInstanceEntity) {
            PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)instance;
            String label = planItemInstanceEntity.getPlanItemDefinitionId();
            if (StringUtils.isNotEmpty((CharSequence)planItemInstanceEntity.getPlanItemDefinition().getName())) {
                label = planItemInstanceEntity.getPlanItemDefinition().getName();
            }
            loggingNode = CmmnLoggingSessionUtil.fillPlanItemInstanceInfo("Evaluate sentry parts for " + label, planItemInstanceEntity, objectMapper);
            caseDefinitionId = planItemInstanceEntity.getCaseDefinitionId();
        } else {
            CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)instance;
            loggingNode = LoggingSessionUtil.fillLoggingData((String)("Evaluate sentry parts for case instance " + instance.getId()), (String)caseInstanceEntity.getId(), null, (String)"cmmn", (ObjectMapper)objectMapper);
            caseDefinitionId = caseInstanceEntity.getCaseDefinitionId();
        }
        CmmnLoggingSessionUtil.fillScopeDefinitionInfo(caseDefinitionId, loggingNode);
        return loggingNode;
    }

    protected static void fillPlanItemDefinitionInfo(ObjectNode loggingNode, PlanItemInstanceEntity planItemInstanceEntity) {
        PlanItemDefinition planItemDefinition = planItemInstanceEntity.getPlanItemDefinition();
        if (planItemDefinition != null) {
            loggingNode.put("elementId", planItemDefinition.getId());
            CmmnLoggingSessionUtil.putIfNotNull("elementName", planItemDefinition.getName(), loggingNode);
            loggingNode.put("elementType", planItemDefinition.getClass().getSimpleName());
        }
    }

    protected static void putIfNotNull(String name, String value, ObjectNode loggingNode) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            loggingNode.put(name, value);
        }
    }

    protected static void putIfNotNull(String name, Integer value, ObjectNode loggingNode) {
        if (value != null) {
            loggingNode.put(name, value);
        }
    }

    protected static void putIfNotNull(String name, Date value, ObjectNode loggingNode) {
        if (value != null) {
            loggingNode.put(name, LoggingSessionUtil.formatDate((Date)value));
        }
    }
}

