/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.util;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstanceState;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceContainer;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.Criterion;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemControl;
import org.flowable.cmmn.model.RepetitionRule;
import org.flowable.cmmn.model.Stage;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class ExpressionUtil {
    public static boolean evaluateBooleanExpression(CommandContext commandContext, VariableContainer variableContainer, String condition) {
        Object evaluationResult = ExpressionUtil.evaluateExpression(commandContext, variableContainer, condition);
        if (evaluationResult instanceof Boolean) {
            return (Boolean)evaluationResult;
        }
        if (evaluationResult instanceof String) {
            return "true".equals(((String)evaluationResult).toLowerCase());
        }
        throw new FlowableException("Expression condition " + condition + " did not evaluate to a boolean value");
    }

    public static Object evaluateExpression(CommandContext commandContext, VariableContainer variableContainer, String expression) {
        Expression exp = CommandContextUtil.getExpressionManager(commandContext).createExpression(expression);
        return exp.getValue(variableContainer);
    }

    public static boolean isRequiredPlanItemInstance(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        PlanItemControl planItemControl = planItemInstanceEntity.getPlanItem().getItemControl();
        if (planItemControl != null && planItemControl.getRequiredRule() != null) {
            boolean isRequired = true;
            String requiredCondition = planItemControl.getRequiredRule().getCondition();
            if (StringUtils.isNotEmpty((CharSequence)requiredCondition)) {
                isRequired = ExpressionUtil.evaluateBooleanExpression(commandContext, (VariableContainer)planItemInstanceEntity, requiredCondition);
            }
            return isRequired;
        }
        return false;
    }

    public static boolean hasOnParts(PlanItem planItem) {
        if (planItem.getEntryCriteria() != null && planItem.getEntryCriteria().size() > 0) {
            for (Criterion criterion : planItem.getEntryCriteria()) {
                if (criterion.getSentry() == null || criterion.getSentry().getOnParts() == null || criterion.getSentry().getOnParts().size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasRepetitionRule(PlanItemInstanceEntity planItemInstanceEntity) {
        return ExpressionUtil.getRepetitionRule(planItemInstanceEntity) != null;
    }

    public static boolean hasRepetitionRule(PlanItem planItem) {
        return planItem.getItemControl() != null && planItem.getItemControl().getRepetitionRule() != null;
    }

    public static RepetitionRule getRepetitionRule(PlanItemInstanceEntity planItemInstanceEntity) {
        if (planItemInstanceEntity != null && planItemInstanceEntity.getPlanItem() != null && planItemInstanceEntity.getPlanItem().getItemControl() != null) {
            return planItemInstanceEntity.getPlanItem().getItemControl().getRepetitionRule();
        }
        return null;
    }

    public static boolean hasRepetitionOnCollection(PlanItemInstanceEntity planItemInstanceEntity) {
        RepetitionRule repetitionRule = ExpressionUtil.getRepetitionRule(planItemInstanceEntity);
        return repetitionRule != null && repetitionRule.hasCollectionVariable();
    }

    public static boolean hasRepetitionOnCollection(PlanItem planItem) {
        if (planItem.getItemControl() == null) {
            return false;
        }
        if (planItem.getItemControl().getRepetitionRule() == null) {
            return false;
        }
        return planItem.getItemControl().getRepetitionRule().hasCollectionVariable();
    }

    public static Iterable<Object> evaluateRepetitionCollectionVariableValue(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        Object collection;
        RepetitionRule repetitionRule = ExpressionUtil.getRepetitionRule(planItemInstanceEntity);
        if (repetitionRule == null || !repetitionRule.hasCollectionVariable()) {
            return null;
        }
        String collectionExpression = repetitionRule.getCollectionVariableName();
        if (!collectionExpression.startsWith("${") && !collectionExpression.startsWith("#{")) {
            collectionExpression = "${vars:getOrDefault('" + collectionExpression + "', null)}";
        }
        if ((collection = ExpressionUtil.evaluateExpression(commandContext, (VariableContainer)planItemInstanceEntity, collectionExpression)) == null) {
            return null;
        }
        if (collection instanceof Iterable) {
            return (Iterable)collection;
        }
        throw new FlowableIllegalArgumentException("Could not evaluate collection for repetition rule on plan item with id '" + planItemInstanceEntity.getId() + "', collection variable name '" + repetitionRule.getCollectionVariableName() + "' evaluated to '" + collection + "', but needs to be a collection, an iterable or an ArrayNode (JSON).");
    }

    public static boolean evaluateRepetitionRule(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity, PlanItemInstanceContainer planItemInstanceContainer) {
        RepetitionRule repetitionRule = ExpressionUtil.getRepetitionRule(planItemInstanceEntity);
        if (repetitionRule != null) {
            if (repetitionRule.hasLimitedInstanceCount() && repetitionRule.getMaxInstanceCount() <= ExpressionUtil.searchNonFinishedEqualPlanItemInstances(planItemInstanceEntity, planItemInstanceContainer).size()) {
                return false;
            }
            String repetitionCondition = repetitionRule.getCondition();
            return ExpressionUtil.evaluateRepetitionRule(commandContext, (VariableContainer)planItemInstanceEntity, repetitionCondition);
        }
        return false;
    }

    public static List<PlanItemInstance> searchNonFinishedEqualPlanItemInstances(PlanItemInstanceEntity planItemInstanceEntity, PlanItemInstanceContainer planItemInstanceContainer) {
        if (planItemInstanceContainer != null && planItemInstanceContainer.getChildPlanItemInstances() != null) {
            return planItemInstanceContainer.getChildPlanItemInstances().stream().filter(pi -> planItemInstanceEntity.getPlanItem().getId().equals(pi.getPlanItem().getId())).filter(pi -> !PlanItemInstanceState.isInTerminalState((PlanItemInstance)pi)).filter(pi -> !pi.getId().equals(planItemInstanceEntity.getId())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static boolean evaluateRepetitionRule(CommandContext commandContext, VariableContainer variableContainer, String repetitionCondition) {
        if (StringUtils.isNotEmpty((CharSequence)repetitionCondition)) {
            return ExpressionUtil.evaluateBooleanExpression(commandContext, variableContainer, repetitionCondition);
        }
        return true;
    }

    public static boolean isCompletionNeutralPlanItemInstance(PlanItemInstanceEntity planItemInstanceEntity) {
        return ExpressionUtil.isCompletionNeutralPlanItemInstance(CommandContextUtil.getCommandContext(), planItemInstanceEntity);
    }

    public static boolean isCompletionNeutralPlanItemInstance(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        PlanItemControl planItemControl = planItemInstanceEntity.getPlanItem().getItemControl();
        if (planItemControl != null && planItemControl.getCompletionNeutralRule() != null) {
            boolean isCompletionNeutral = true;
            String condition = planItemControl.getCompletionNeutralRule().getCondition();
            if (StringUtils.isNotEmpty((CharSequence)condition)) {
                isCompletionNeutral = ExpressionUtil.evaluateBooleanExpression(commandContext, (VariableContainer)planItemInstanceEntity, condition);
            }
            return isCompletionNeutral;
        }
        return false;
    }

    public static boolean evaluateAutoComplete(CommandContext commandContext, VariableContainer variableContainer, Stage stage) {
        if (StringUtils.isNotEmpty((CharSequence)stage.getAutoCompleteCondition())) {
            return ExpressionUtil.evaluateBooleanExpression(commandContext, variableContainer, stage.getAutoCompleteCondition());
        }
        return stage.isAutoComplete();
    }
}

