/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.util;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.api.history.HistoricTaskLogEntryBuilder;
import org.flowable.task.api.history.HistoricTaskLogEntryType;
import org.flowable.task.service.TaskServiceConfiguration;
import org.flowable.task.service.impl.BaseHistoricTaskLogEntryBuilderImpl;
import org.flowable.task.service.impl.persistence.CountingTaskEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class IdentityLinkUtil {
    public static IdentityLinkEntity createCaseInstanceIdentityLink(CaseInstance caseInstance, String userId, String groupId, String type, CmmnEngineConfiguration cmmnEngineConfiguration) {
        IdentityLinkEntity identityLinkEntity = cmmnEngineConfiguration.getIdentityLinkServiceConfiguration().getIdentityLinkService().createScopeIdentityLink(null, caseInstance.getId(), "cmmn", userId, groupId, type);
        CommandContextUtil.getCmmnHistoryManager().recordIdentityLinkCreated(identityLinkEntity);
        return identityLinkEntity;
    }

    public static void deleteTaskIdentityLinks(TaskEntity taskEntity, String userId, String groupId, String type, CmmnEngineConfiguration cmmnEngineConfiguration) {
        List removedIdentityLinkEntities = cmmnEngineConfiguration.getIdentityLinkServiceConfiguration().getIdentityLinkService().deleteTaskIdentityLink(taskEntity.getId(), taskEntity.getIdentityLinks(), userId, groupId, type);
        IdentityLinkUtil.handleTaskIdentityLinkDeletions(taskEntity, removedIdentityLinkEntities, true, cmmnEngineConfiguration);
    }

    public static void deleteCaseInstanceIdentityLinks(CaseInstance caseInstance, String userId, String groupId, String type, CmmnEngineConfiguration cmmnEngineConfiguration) {
        List removedIdentityLinkEntities = cmmnEngineConfiguration.getIdentityLinkServiceConfiguration().getIdentityLinkService().deleteScopeIdentityLink(caseInstance.getId(), "cmmn", userId, groupId, type);
        for (IdentityLinkEntity identityLinkEntity : removedIdentityLinkEntities) {
            CommandContextUtil.getCmmnHistoryManager().recordIdentityLinkDeleted(identityLinkEntity);
        }
    }

    public static void handleTaskIdentityLinkAdditions(TaskEntity taskEntity, List<IdentityLinkEntity> identityLinkEntities, CmmnEngineConfiguration cmmnEngineConfiguration) {
        for (IdentityLinkEntity identityLinkEntity : identityLinkEntities) {
            IdentityLinkUtil.handleTaskIdentityLinkAddition(taskEntity, identityLinkEntity, cmmnEngineConfiguration);
        }
    }

    public static IdentityLinkEntity createPlanItemInstanceIdentityLink(PlanItemInstance planItemInstance, String userId, String groupId, String type, CmmnEngineConfiguration cmmnEngineConfiguration) {
        IdentityLinkEntity identityLinkEntity = cmmnEngineConfiguration.getIdentityLinkServiceConfiguration().getIdentityLinkService().createSubScopeIdentityLink(null, planItemInstance.getCaseInstanceId(), planItemInstance.getId(), "planItem", userId, groupId, type);
        cmmnEngineConfiguration.getCmmnHistoryManager().recordIdentityLinkCreated(identityLinkEntity);
        return identityLinkEntity;
    }

    public static void handleTaskIdentityLinkAddition(TaskEntity taskEntity, IdentityLinkEntity identityLinkEntity, CmmnEngineConfiguration cmmnEngineConfiguration) {
        cmmnEngineConfiguration.getCmmnHistoryManager().recordIdentityLinkCreated(identityLinkEntity);
        CountingTaskEntity countingTaskEntity = (CountingTaskEntity)taskEntity;
        if (countingTaskEntity.isCountEnabled()) {
            countingTaskEntity.setIdentityLinkCount(countingTaskEntity.getIdentityLinkCount() + 1);
        }
        IdentityLinkUtil.logTaskIdentityLinkEvent(HistoricTaskLogEntryType.USER_TASK_IDENTITY_LINK_ADDED.name(), taskEntity, identityLinkEntity, cmmnEngineConfiguration);
        taskEntity.getIdentityLinks().add(identityLinkEntity);
        if (cmmnEngineConfiguration.getIdentityLinkInterceptor() != null) {
            cmmnEngineConfiguration.getIdentityLinkInterceptor().handleAddIdentityLinkToTask(taskEntity, identityLinkEntity);
        }
    }

    public static void handleTaskIdentityLinkDeletions(TaskEntity taskEntity, List<IdentityLinkEntity> identityLinks, boolean cascaseHistory, CmmnEngineConfiguration cmmnEngineConfiguration) {
        for (IdentityLinkEntity identityLinkEntity : identityLinks) {
            CountingTaskEntity countingTaskEntity = (CountingTaskEntity)taskEntity;
            if (countingTaskEntity.isCountEnabled()) {
                countingTaskEntity.setIdentityLinkCount(countingTaskEntity.getIdentityLinkCount() - 1);
            }
            if (cascaseHistory) {
                CommandContextUtil.getCmmnHistoryManager().recordIdentityLinkDeleted(identityLinkEntity);
            }
            IdentityLinkUtil.logTaskIdentityLinkEvent(HistoricTaskLogEntryType.USER_TASK_IDENTITY_LINK_REMOVED.name(), taskEntity, identityLinkEntity, cmmnEngineConfiguration);
        }
        taskEntity.getIdentityLinks().removeAll(identityLinks);
    }

    protected static void logTaskIdentityLinkEvent(String eventType, TaskEntity taskEntity, IdentityLinkEntity identityLinkEntity, CmmnEngineConfiguration cmmnEngineConfiguration) {
        TaskServiceConfiguration taskServiceConfiguration = cmmnEngineConfiguration.getTaskServiceConfiguration();
        if (taskServiceConfiguration.isEnableHistoricTaskLogging()) {
            BaseHistoricTaskLogEntryBuilderImpl taskLogEntryBuilder = new BaseHistoricTaskLogEntryBuilderImpl((TaskInfo)taskEntity);
            ObjectNode data = taskServiceConfiguration.getObjectMapper().createObjectNode();
            if (identityLinkEntity.isUser()) {
                data.put("userId", identityLinkEntity.getUserId());
            } else if (identityLinkEntity.isGroup()) {
                data.put("groupId", identityLinkEntity.getGroupId());
            }
            data.put("type", identityLinkEntity.getType());
            taskLogEntryBuilder.timeStamp(taskServiceConfiguration.getClock().getCurrentTime());
            taskLogEntryBuilder.userId(Authentication.getAuthenticatedUserId());
            taskLogEntryBuilder.data(data.toString());
            taskLogEntryBuilder.type(eventType);
            taskServiceConfiguration.getInternalHistoryTaskManager().recordHistoryUserTaskLog((HistoricTaskLogEntryBuilder)taskLogEntryBuilder);
        }
    }
}

