/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.editor.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.editor.json.converter.AbstractEventListenerJsonConverter;
import org.flowable.cmmn.editor.json.converter.ActivityProcessor;
import org.flowable.cmmn.editor.json.converter.BaseCmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterContext;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterUtil;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.EventListener;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.TimerEventListener;

public class TimerEventListenerJsonConverter
extends AbstractEventListenerJsonConverter {
    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "TimerEventListener";
    }

    public static void fillTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToCmmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        TimerEventListenerJsonConverter.fillJsonTypes(convertersToCmmnMap);
        TimerEventListenerJsonConverter.fillCmmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("TimerEventListener", TimerEventListenerJsonConverter.class);
    }

    public static void fillCmmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(TimerEventListener.class, TimerEventListenerJsonConverter.class);
    }

    @Override
    protected void convertElementToJson(ObjectNode elementNode, ObjectNode propertiesNode, ActivityProcessor processor, BaseElement baseElement, CmmnModel cmmnModel, CmmnJsonConverterContext converterContext) {
        PlanItem planItem = (PlanItem)baseElement;
        TimerEventListener timerEventListener = (TimerEventListener)planItem.getPlanItemDefinition();
        propertiesNode.put("timerexpression", timerEventListener.getTimerExpression());
        if (timerEventListener.getTimerStartTriggerSourceRef() != null) {
            ObjectNode startTriggerPlanItemNode = propertiesNode.putObject("timerstarttriggersourceref");
            startTriggerPlanItemNode.put("id", timerEventListener.getTimerStartTriggerSourceRef());
            propertiesNode.put("transitionevent", timerEventListener.getTimerStartTriggerStandardEvent());
        }
        this.convertCommonElementToJson(elementNode, propertiesNode, baseElement);
    }

    @Override
    protected BaseElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, ActivityProcessor processor, BaseElement parentElement, Map<String, JsonNode> shapeMap, CmmnModel cmmnModel, CmmnJsonConverterContext converterContext, CmmnJsonConverter.CmmnModelIdHelper cmmnModelIdHelper) {
        JsonNode referencedNode;
        TimerEventListener timerEventListener = new TimerEventListener();
        timerEventListener.setTimerExpression(CmmnJsonConverterUtil.getPropertyValueAsString("timerexpression", elementNode));
        String sourceRefId = null;
        JsonNode sourceRefNode = CmmnJsonConverterUtil.getProperty("timerstarttriggersourceref", elementNode);
        if (sourceRefNode != null && sourceRefNode.has("id")) {
            sourceRefId = sourceRefNode.get("id").asText();
        }
        if (StringUtils.isNotEmpty(sourceRefId) && (referencedNode = shapeMap.get(sourceRefId)) != null) {
            timerEventListener.setTimerStartTriggerSourceRef(CmmnJsonConverterUtil.getElementId(referencedNode));
            timerEventListener.setTimerStartTriggerStandardEvent(CmmnJsonConverterUtil.getPropertyValueAsString("transitionevent", elementNode));
        }
        this.convertCommonJsonToElement(elementNode, (EventListener)timerEventListener);
        return timerEventListener;
    }
}

