/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.engine.impl.test;

import java.util.ArrayList;
import java.util.List;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.db.SchemaManager;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.test.EnsureCleanDbUtils;
import org.flowable.content.api.ContentManagementService;
import org.flowable.content.api.ContentService;
import org.flowable.content.engine.ContentEngine;
import org.flowable.content.engine.ContentEngineConfiguration;
import org.flowable.content.engine.impl.test.AbstractContentTestCase;
import org.flowable.content.engine.impl.util.CommandContextUtil;
import org.slf4j.Logger;

public abstract class AbstractFlowableTestCase
extends AbstractContentTestCase {
    private static final List<String> TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK = new ArrayList<String>();
    protected ContentEngine contentEngine;
    protected Throwable exception;
    protected ContentEngineConfiguration contentEngineConfiguration;
    protected ContentManagementService managementService;
    protected ContentService contentService;

    protected abstract void initializeContentEngine();

    protected void closeDownContentEngine() {
    }

    protected void nullifyServices() {
        this.contentEngineConfiguration = null;
        this.managementService = null;
        this.contentService = null;
    }

    public void runBare() throws Throwable {
        this.initializeContentEngine();
        if (this.contentService == null) {
            this.initializeServices();
        }
        try {
            super.runBare();
        }
        catch (AssertionError e) {
            LOGGER.error("\n");
            LOGGER.error("ASSERTION FAILED: {}", (Object)e, (Object)e);
            this.exception = e;
            throw e;
        }
        catch (Throwable e) {
            LOGGER.error("\n");
            LOGGER.error("EXCEPTION: {}", (Object)e, (Object)e);
            this.exception = e;
            throw e;
        }
        finally {
            this.assertAndEnsureCleanDb();
            this.contentEngineConfiguration.getClock().reset();
            this.closeDownContentEngine();
        }
    }

    protected void assertAndEnsureCleanDb() throws Throwable {
        EnsureCleanDbUtils.assertAndEnsureCleanDb((String)this.getName(), (Logger)LOGGER, (AbstractEngineConfiguration)this.contentEngineConfiguration, TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK, (this.exception == null ? 1 : 0) != 0, (Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                SchemaManager schemaManager = CommandContextUtil.getContentEngineConfiguration(commandContext).getSchemaManager();
                schemaManager.schemaDrop();
                schemaManager.schemaCreate();
                return null;
            }
        });
    }

    protected void initializeServices() {
        this.contentEngineConfiguration = this.contentEngine.getContentEngineConfiguration();
        this.managementService = this.contentEngine.getContentManagementService();
        this.contentService = this.contentEngine.getContentService();
    }

    static {
        TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK.add("ACT_CO_DATABASECHANGELOG");
        TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK.add("ACT_CO_DATABASECHANGELOGLOCK");
        TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK.add("ACT_GE_PROPERTY");
    }
}

