/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.event;

import java.util.List;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.Association;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.CompensateEventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.bpmn.helper.ScopeUtil;
import org.flowable.engine.impl.event.EventHandler;
import org.flowable.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.flowable.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;

public class CompensationEventHandler
implements EventHandler {
    @Override
    public String getEventHandlerType() {
        return "compensate";
    }

    @Override
    public void handleEvent(EventSubscriptionEntity eventSubscription, Object payload, CommandContext commandContext) {
        String configuration = eventSubscription.getConfiguration();
        if (configuration == null) {
            throw new FlowableException("Compensating execution not set for compensate event subscription with id " + eventSubscription.getId());
        }
        ExecutionEntity compensatingExecution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(configuration);
        String processDefinitionId = compensatingExecution.getProcessDefinitionId();
        Process process = ProcessDefinitionUtil.getProcess(processDefinitionId);
        if (process == null) {
            throw new FlowableException("Cannot start process instance. Process model (id = " + processDefinitionId + ") could not be found");
        }
        FlowElement flowElement = process.getFlowElement(eventSubscription.getActivityId(), true);
        if (flowElement instanceof SubProcess && !((SubProcess)flowElement).isForCompensation()) {
            compensatingExecution.setScope(true);
            List<CompensateEventSubscriptionEntity> eventsForThisScope = CommandContextUtil.getEventSubscriptionEntityManager(commandContext).findCompensateEventSubscriptionsByExecutionId(compensatingExecution.getId());
            ScopeUtil.throwCompensationEvent(eventsForThisScope, compensatingExecution, false);
        } else {
            try {
                if (CommandContextUtil.getProcessEngineConfiguration(commandContext).getEventDispatcher().isEnabled()) {
                    CommandContextUtil.getProcessEngineConfiguration(commandContext).getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createActivityEvent(FlowableEngineEventType.ACTIVITY_COMPENSATE, flowElement.getId(), flowElement.getName(), compensatingExecution.getId(), compensatingExecution.getProcessInstanceId(), compensatingExecution.getProcessDefinitionId(), flowElement));
                }
                Activity compensationActivity = null;
                Activity activity = (Activity)flowElement;
                if (!activity.isForCompensation() && activity.getBoundaryEvents().size() > 0) {
                    block2: for (BoundaryEvent boundaryEvent : activity.getBoundaryEvents()) {
                        if (boundaryEvent.getEventDefinitions().size() <= 0 || !(boundaryEvent.getEventDefinitions().get(0) instanceof CompensateEventDefinition)) continue;
                        List associations = process.findAssociationsWithSourceRefRecursive(boundaryEvent.getId());
                        for (Association association : associations) {
                            Activity targetActivity;
                            FlowElement targetElement = process.getFlowElement(association.getTargetRef(), true);
                            if (!(targetElement instanceof Activity) || !(targetActivity = (Activity)targetElement).isForCompensation()) continue;
                            compensationActivity = targetActivity;
                            continue block2;
                        }
                    }
                }
                if (compensationActivity != null) {
                    flowElement = compensationActivity;
                }
                compensatingExecution.setCurrentFlowElement(flowElement);
                CommandContextUtil.getAgenda().planContinueProcessInCompensation(compensatingExecution);
            }
            catch (Exception e) {
                throw new FlowableException("Error while handling compensation event " + eventSubscription, (Throwable)e);
            }
        }
    }
}

