/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.bpmn.model.AdhocSubProcess;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.runtime.Execution;

public class ExecuteActivityForAdhocSubProcessCmd
implements Command<Execution>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String executionId;
    protected String activityId;

    public ExecuteActivityForAdhocSubProcessCmd(String executionId, String activityId) {
        this.executionId = executionId;
        this.activityId = activityId;
    }

    public Execution execute(CommandContext commandContext) {
        ExecutionEntity execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(this.executionId);
        if (execution == null) {
            throw new FlowableObjectNotFoundException("No execution found for id '" + this.executionId + "'", ExecutionEntity.class);
        }
        if (!(execution.getCurrentFlowElement() instanceof AdhocSubProcess)) {
            throw new FlowableException("The current flow element of the requested execution is not an ad-hoc sub process");
        }
        FlowNode foundNode = null;
        AdhocSubProcess adhocSubProcess = (AdhocSubProcess)execution.getCurrentFlowElement();
        if (adhocSubProcess.hasSequentialOrdering() && execution.getExecutions().size() > 0) {
            throw new FlowableException("Sequential ad-hoc sub process already has an active execution");
        }
        for (FlowElement flowElement : adhocSubProcess.getFlowElements()) {
            FlowNode flowNode;
            if (!this.activityId.equals(flowElement.getId()) || !(flowElement instanceof FlowNode) || (flowNode = (FlowNode)flowElement).getIncomingFlows().size() != 0) continue;
            foundNode = flowNode;
        }
        if (foundNode == null) {
            throw new FlowableException("The requested activity with id " + this.activityId + " can not be enabled");
        }
        ExecutionEntity activityExecution = CommandContextUtil.getExecutionEntityManager().createChildExecution(execution);
        activityExecution.setCurrentFlowElement((FlowElement)foundNode);
        CommandContextUtil.getAgenda().planContinueProcessOperation(activityExecution);
        return activityExecution;
    }
}

