/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.async.json.transformer.AbstractHistoryJsonTransformer;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.flowable.variable.api.types.VariableType;
import org.flowable.variable.api.types.VariableTypes;
import org.flowable.variable.service.impl.persistence.entity.HistoricVariableInstanceEntity;

public class VariableUpdatedHistoryJsonTransformer
extends AbstractHistoryJsonTransformer {
    public VariableUpdatedHistoryJsonTransformer(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    public List<String> getTypes() {
        return Collections.singletonList("variable-updated");
    }

    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        return this.processEngineConfiguration.getVariableServiceConfiguration().getHistoricVariableService().getHistoricVariableInstance(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"id")) != null;
    }

    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        HistoricVariableInstanceEntity historicVariable = this.processEngineConfiguration.getVariableServiceConfiguration().getHistoricVariableService().getHistoricVariableInstance(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"id"));
        Date time = AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"lastUpdatedTime");
        if (historicVariable.getLastUpdatedTime().after(time)) {
            return;
        }
        VariableTypes variableTypes = this.processEngineConfiguration.getVariableTypes();
        VariableType variableType = variableTypes.getVariableType(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"variableType"));
        historicVariable.setVariableType(variableType);
        historicVariable.setTextValue(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"variableTextValue"));
        historicVariable.setTextValue2(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"variableTextValue2"));
        historicVariable.setDoubleValue(AsyncHistoryJsonUtil.getDoubleFromJson((ObjectNode)historicalData, (String)"variableDoubleValue"));
        historicVariable.setLongValue(AsyncHistoryJsonUtil.getLongFromJson((ObjectNode)historicalData, (String)"variableLongValue"));
        String variableBytes = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"variableBytesValue");
        if (StringUtils.isNotEmpty((CharSequence)variableBytes)) {
            historicVariable.setBytes(Base64.getDecoder().decode(variableBytes));
        } else {
            historicVariable.setBytes(null);
        }
        historicVariable.setLastUpdatedTime(time);
    }
}

