/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.debug;

import java.util.Iterator;
import java.util.List;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.engine.debug.ExecutionTreeBfsIterator;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;

public class ExecutionTreeNode
implements Iterable<ExecutionTreeNode> {
    protected ExecutionEntity executionEntity;
    protected ExecutionTreeNode parent;
    protected List<ExecutionTreeNode> children;

    public ExecutionTreeNode(ExecutionEntity executionEntity) {
        this.executionEntity = executionEntity;
    }

    public ExecutionEntity getExecutionEntity() {
        return this.executionEntity;
    }

    public void setExecutionEntity(ExecutionEntity executionEntity) {
        this.executionEntity = executionEntity;
    }

    public ExecutionTreeNode getParent() {
        return this.parent;
    }

    public void setParent(ExecutionTreeNode parent) {
        this.parent = parent;
    }

    public List<ExecutionTreeNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<ExecutionTreeNode> children) {
        this.children = children;
    }

    @Override
    public Iterator<ExecutionTreeNode> iterator() {
        return new ExecutionTreeBfsIterator(this);
    }

    public ExecutionTreeBfsIterator leafsFirstIterator() {
        return new ExecutionTreeBfsIterator(this, true);
    }

    public String toString() {
        StringBuilder strb = new StringBuilder();
        strb.append(this.getExecutionEntity().getId());
        if (this.getExecutionEntity().getActivityId() != null) {
            strb.append(" : ").append(this.getExecutionEntity().getActivityId());
        }
        if (this.getExecutionEntity().getParentId() != null) {
            strb.append(", parent id ").append(this.getExecutionEntity().getParentId());
        }
        if (this.getExecutionEntity().isProcessInstanceType()) {
            strb.append(" (process instance)");
        }
        strb.append(System.lineSeparator());
        if (this.children != null) {
            for (ExecutionTreeNode childNode : this.children) {
                childNode.internalToString(strb, "", true);
            }
        }
        return strb.toString();
    }

    protected void internalToString(StringBuilder strb, String prefix, boolean isTail) {
        strb.append(prefix).append(isTail ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ").append(this.getExecutionEntity().getId()).append(" : ").append(this.getCurrentFlowElementId()).append(", parent id ").append(this.getExecutionEntity().getParentId()).append(this.getExecutionEntity().isActive() ? " (active)" : " (not active)").append(this.getExecutionEntity().isScope() ? " (scope)" : "").append(this.getExecutionEntity().isMultiInstanceRoot() ? " (multi instance root)" : "").append(this.getExecutionEntity().isEnded() ? " (ended)" : "").append(System.lineSeparator());
        if (this.children != null) {
            for (int i = 0; i < this.children.size() - 1; ++i) {
                this.children.get(i).internalToString(strb, prefix + (isTail ? "    " : "\u2502   "), false);
            }
            if (this.children.size() > 0) {
                this.children.get(this.children.size() - 1).internalToString(strb, prefix + (isTail ? "    " : "\u2502   "), true);
            }
        }
    }

    protected String getCurrentFlowElementId() {
        FlowElement flowElement = this.getExecutionEntity().getCurrentFlowElement();
        if (flowElement instanceof SequenceFlow) {
            SequenceFlow sequenceFlow = (SequenceFlow)flowElement;
            return sequenceFlow.getSourceRef() + " -> " + sequenceFlow.getTargetRef();
        }
        if (flowElement != null) {
            return flowElement.getId() + " (" + flowElement.getClass().getSimpleName();
        }
        return "";
    }
}

