/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.Date;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.db.SuspensionState;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.runtime.Clock;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.task.api.Task;
import org.flowable.task.service.HistoricTaskService;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class ActivateTaskCmd
implements Command<Void> {
    protected String taskId;
    protected String userId;

    public ActivateTaskCmd(String taskId, String userId) {
        this.taskId = taskId;
        this.userId = userId;
    }

    public Void execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        if (this.taskId == null) {
            throw new FlowableIllegalArgumentException("taskId is null");
        }
        TaskEntity task = processEngineConfiguration.getTaskServiceConfiguration().getTaskService().getTask(this.taskId);
        if (task == null) {
            throw new FlowableObjectNotFoundException("Cannot find task with id " + this.taskId, Task.class);
        }
        if (task.isDeleted()) {
            throw new FlowableException(task + " is already deleted");
        }
        if (!task.isSuspended()) {
            throw new FlowableException(task + " is not suspended, so can't be activated");
        }
        Clock clock = processEngineConfiguration.getClock();
        Date updateTime = clock.getCurrentTime();
        task.setSuspendedTime(null);
        task.setSuspendedBy(null);
        if (task.getInProgressStartTime() != null) {
            task.setState("inProgress");
        } else if (task.getClaimTime() != null) {
            task.setState("claimed");
        } else {
            task.setState("created");
        }
        task.setSuspensionState(SuspensionState.ACTIVE.getStateCode());
        HistoricTaskService historicTaskService = processEngineConfiguration.getTaskServiceConfiguration().getHistoricTaskService();
        historicTaskService.recordTaskInfoChange(task, updateTime, (AbstractEngineConfiguration)processEngineConfiguration);
        return null;
    }
}

