/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;

public class DeleteHistoricProcessInstanceCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;

    public DeleteHistoricProcessInstanceCmd(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public Object execute(CommandContext commandContext) {
        if (this.processInstanceId == null) {
            throw new FlowableIllegalArgumentException("processInstanceId is null");
        }
        HistoricProcessInstance instance = (HistoricProcessInstance)CommandContextUtil.getHistoricProcessInstanceEntityManager(commandContext).findById(this.processInstanceId);
        if (instance == null) {
            throw new FlowableObjectNotFoundException("No historic process instance found with id: " + this.processInstanceId, HistoricProcessInstance.class);
        }
        if (instance.getEndTime() == null) {
            throw new FlowableException("Process instance is still running, cannot delete " + instance);
        }
        if (Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, instance.getProcessDefinitionId())) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            compatibilityHandler.deleteHistoricProcessInstance(this.processInstanceId);
            return null;
        }
        CommandContextUtil.getHistoryManager(commandContext).recordProcessInstanceDeleted(this.processInstanceId, instance.getProcessDefinitionId(), instance.getTenantId());
        return null;
    }
}

