/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.List;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateV5EntitiesCmd
implements Command<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidateV5EntitiesCmd.class);

    public Void execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        if (!processEngineConfiguration.isFlowable5CompatibilityEnabled() || processEngineConfiguration.getFlowable5CompatibilityHandler() == null) {
            RepositoryService repositoryService = processEngineConfiguration.getRepositoryService();
            long numberOfV5Deployments = repositoryService.createDeploymentQuery().deploymentEngineVersion("v5").count();
            LOGGER.info("Total of v5 deployments found: {}", (Object)numberOfV5Deployments);
            if (numberOfV5Deployments > 0L) {
                List processDefinitions = repositoryService.createProcessDefinitionQuery().latestVersion().processDefinitionEngineVersion("v5").list();
                if (!processDefinitions.isEmpty()) {
                    String message = "Found v5 process definitions that are the latest version." + " Enable the 'flowable5CompatibilityEnabled' property in the process engine configuration" + " and make sure the flowable5-compatibility dependency is available on the classpath";
                    LOGGER.error(message);
                    for (ProcessDefinition processDefinition : processDefinitions) {
                        LOGGER.error("Found v5 process definition with id: {}, and key: {}", (Object)processDefinition.getId(), (Object)processDefinition.getKey());
                    }
                    throw new FlowableException(message);
                }
                RuntimeService runtimeService = processEngineConfiguration.getRuntimeService();
                long numberOfV5ProcessInstances = runtimeService.createProcessInstanceQuery().processDefinitionEngineVersion("v5").count();
                if (numberOfV5ProcessInstances > 0L) {
                    String message = "Found at least one running v5 process instance." + " Enable the 'flowable5CompatibilityEnabled' property in the process engine configuration" + " and make sure the flowable5-compatibility dependency is available on the classpath";
                    LOGGER.error(message);
                    throw new FlowableException(message);
                }
            }
        }
        return null;
    }
}

