/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.externalworker;

import java.util.LinkedHashMap;
import java.util.Map;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.engine.impl.cmd.ExternalWorkerJobBpmnErrorCmd;
import org.flowable.engine.impl.cmd.ExternalWorkerJobCompleteCmd;
import org.flowable.engine.runtime.ExternalWorkerCompletionBuilder;
import org.flowable.job.service.JobServiceConfiguration;

public class ExternalWorkerCompletionBuilderImpl
implements ExternalWorkerCompletionBuilder {
    protected final CommandExecutor commandExecutor;
    protected final String externalJobId;
    protected final String workerId;
    protected final JobServiceConfiguration jobServiceConfiguration;
    protected Map<String, Object> variables;

    public ExternalWorkerCompletionBuilderImpl(CommandExecutor commandExecutor, String externalJobId, String workerId, JobServiceConfiguration jobServiceConfiguration) {
        this.commandExecutor = commandExecutor;
        this.externalJobId = externalJobId;
        this.workerId = workerId;
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    @Override
    public ExternalWorkerCompletionBuilder variables(Map<String, Object> variables) {
        if (this.variables == null) {
            this.variables = new LinkedHashMap<String, Object>();
        }
        this.variables.putAll(variables);
        return this;
    }

    @Override
    public ExternalWorkerCompletionBuilder variable(String name, Object value) {
        if (this.variables == null) {
            this.variables = new LinkedHashMap<String, Object>();
        }
        this.variables.put(name, value);
        return this;
    }

    @Override
    public void complete() {
        this.commandExecutor.execute((Command)new ExternalWorkerJobCompleteCmd(this.externalJobId, this.workerId, this.variables, this.jobServiceConfiguration));
    }

    @Override
    public void bpmnError(String errorCode) {
        this.commandExecutor.execute((Command)new ExternalWorkerJobBpmnErrorCmd(this.externalJobId, this.workerId, this.variables, errorCode, this.jobServiceConfiguration));
    }
}

