/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.jobexecutor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.job.service.JobHandler;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncLeaveJobHandler
implements JobHandler {
    public static final Logger LOGGER = LoggerFactory.getLogger(AsyncLeaveJobHandler.class);
    public static final String TYPE = "async-after";
    private static final String FIELD_EVALUATE_CONDITIONS = "evaluateConditions";
    private static final String FIELD_SEQUENCE_FLOW_ID = "sequenceFlowId";
    private static final String FIELD_SEQUENCE_FLOW_SOURCE = "source";
    private static final String FIELD_SEQUENCE_FLOW_TARGET = "target";
    private static final String FIELD_SEQUENCE_FLOW_LINE_NR = "lineNr";
    private static final String FIELD_SEQUENCE_FLOW_LINE_COLUMN_NR = "colNr";

    public String getType() {
        return TYPE;
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        ExecutionEntity executionEntity = (ExecutionEntity)variableScope;
        ObjectMapper objectMapper = CommandContextUtil.getProcessEngineConfiguration(commandContext).getObjectMapper();
        if (configuration != null) {
            try {
                JsonNode jobConfigurationJson = objectMapper.readTree(configuration);
                boolean evaluateConditions = false;
                JsonNode evaluateConditionsNode = jobConfigurationJson.path(FIELD_EVALUATE_CONDITIONS);
                if (evaluateConditionsNode != null && evaluateConditionsNode.isBoolean()) {
                    evaluateConditions = evaluateConditionsNode.booleanValue();
                }
                if (this.isAsyncLeaveWithSpecificSequenceFlow(jobConfigurationJson)) {
                    executionEntity.setCurrentFlowElement((FlowElement)this.determineSequenceFlow(job, executionEntity, jobConfigurationJson));
                }
                CommandContextUtil.getAgenda(commandContext).planTakeOutgoingSequenceFlowsSynchronousOperation(executionEntity, evaluateConditions);
            }
            catch (JsonProcessingException e) {
                LOGGER.warn("Programmatic error: could not parse job configuration JSON", (Throwable)e);
            }
        }
    }

    protected boolean isAsyncLeaveWithSpecificSequenceFlow(JsonNode jobConfigurationJson) {
        return jobConfigurationJson.size() > 1;
    }

    protected SequenceFlow determineSequenceFlow(JobEntity job, ExecutionEntity executionEntity, JsonNode jobConfigurationJson) {
        FlowElement flowElement;
        String sequenceFlowId = null;
        JsonNode sequenceFlowIdJsonNode = jobConfigurationJson.path(FIELD_SEQUENCE_FLOW_ID);
        if (sequenceFlowIdJsonNode != null && !sequenceFlowIdJsonNode.isNull() && !sequenceFlowIdJsonNode.isMissingNode()) {
            sequenceFlowId = sequenceFlowIdJsonNode.asText();
        }
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(executionEntity.getProcessDefinitionId());
        SequenceFlow sequenceFlow = null;
        if (StringUtils.isNotEmpty(sequenceFlowId) && (flowElement = bpmnModel.getMainProcess().getFlowElement(sequenceFlowId)) instanceof SequenceFlow) {
            sequenceFlow = (SequenceFlow)flowElement;
        }
        if (sequenceFlow == null) {
            String source = jobConfigurationJson.path(FIELD_SEQUENCE_FLOW_SOURCE).asText();
            String target = jobConfigurationJson.path(FIELD_SEQUENCE_FLOW_TARGET).asText();
            int lineNr = jobConfigurationJson.path(FIELD_SEQUENCE_FLOW_LINE_NR).asInt();
            int columnNr = jobConfigurationJson.path(FIELD_SEQUENCE_FLOW_LINE_COLUMN_NR).asInt();
            List sequenceFlows = bpmnModel.getMainProcess().findFlowElementsOfType(SequenceFlow.class, true);
            Optional<SequenceFlow> sequenceFlowOptional = sequenceFlows.stream().filter(s -> Objects.equals(source, s.getSourceRef()) && Objects.equals(target, s.getTargetRef()) && lineNr == s.getXmlRowNumber() && columnNr == s.getXmlColumnNumber()).findFirst();
            if (sequenceFlowOptional.isPresent()) {
                sequenceFlow = sequenceFlowOptional.get();
            }
        }
        if (sequenceFlow == null) {
            throw new FlowableException("Programmatic error: no sequence flow could be found for async leave in job " + job);
        }
        return sequenceFlow;
    }

    public static String createJobConfiguration(ProcessEngineConfiguration processEngineConfiguration, boolean evaluateConditions) {
        ObjectMapper objectMapper = processEngineConfiguration.getObjectMapper();
        ObjectNode objectNode = objectMapper.createObjectNode();
        objectNode.put(FIELD_EVALUATE_CONDITIONS, evaluateConditions);
        try {
            return objectMapper.writeValueAsString((Object)objectNode);
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Programmatic error: could not create job configuration JSON", (Throwable)e);
            return null;
        }
    }

    public static String createJobConfiguration(ProcessEngineConfiguration processEngineConfiguration, SequenceFlow sequenceFlow) {
        ObjectMapper objectMapper = processEngineConfiguration.getObjectMapper();
        ObjectNode objectNode = objectMapper.createObjectNode();
        objectNode.put(FIELD_EVALUATE_CONDITIONS, false);
        String sequenceFlowId = sequenceFlow.getId();
        if (StringUtils.isNotEmpty((CharSequence)sequenceFlowId)) {
            objectNode.put(FIELD_SEQUENCE_FLOW_ID, sequenceFlowId);
        } else {
            objectNode.put(FIELD_SEQUENCE_FLOW_SOURCE, sequenceFlow.getSourceRef());
            objectNode.put(FIELD_SEQUENCE_FLOW_TARGET, sequenceFlow.getTargetRef());
            objectNode.put(FIELD_SEQUENCE_FLOW_LINE_NR, sequenceFlow.getXmlRowNumber());
            objectNode.put(FIELD_SEQUENCE_FLOW_LINE_COLUMN_NR, sequenceFlow.getXmlColumnNumber());
        }
        try {
            return objectMapper.writeValueAsString((Object)objectNode);
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Programmatic error: could not create job configuration JSON", (Throwable)e);
            return null;
        }
    }
}

